/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import java.util.StringTokenizer;

public class CommandInput
extends Command {
    public static final String ERR_NO_INPUT_EXPECTED = "ERR_NO_INPUT_EXPECTED";
    public static final String ERR_BAD_INPUT_FORMAT = "ERR_BAD_INPUT_FORMAT";
    private Simulator simulator;
    private String sParameters;

    public CommandInput(StringTokenizer stringTokenizer, String string, Simulator simulator) {
        super(stringTokenizer);
        this.sParameters = string;
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        try {
            String string = this.sParameters.substring(1, this.sParameters.length() - 1);
            int n = this.simulator.iWriteInput(string);
            switch (n) {
                case 0: {
                    break;
                }
                case -1: {
                    commandResultBuffer.append("* INPUT ERR ERR_NO_INPUT_EXPECTED");
                    break;
                }
                case -2: {
                    commandResultBuffer.append("* INPUT ERR ERR_BAD_INPUT_FORMAT");
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidCommandUseException("Invalid format of input or unexpected error.");
        }
        commandResultBuffer.append("* INPUT DONE");
    }
}

