/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.BreakpointList;
import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.GuardExpression;
import JIMSCore.GuardList;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import java.util.StringTokenizer;

public class CommandAdd
extends Command {
    private Simulator simulator;

    public CommandAdd(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        String string = this.nextToken();
        if (string.startsWith("B")) {
            string = this.nextToken();
            int n = 0;
            try {
                n = Command.iGetNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidCommandUseException("Invalid address specified for breakpoint.");
            }
            BreakpointList breakpointList = this.simulator.getBreakpointList();
            int n2 = 1;
            try {
                n2 = breakpointList.iAddBreakpoint(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n2) {
                case 1: {
                    throw new InvalidCommandUseException("Unable to initialize breakpoint list.");
                }
                case -2: {
                    throw new InvalidCommandUseException("Unable to add breakpoint.");
                }
                case -1: {
                    throw new InvalidCommandUseException("Breakpoint already exists at that address.");
                }
            }
        } else {
            if (string.startsWith("G")) {
                string = this.nextToken();
                GuardExpression guardExpression = null;
                try {
                    guardExpression = GuardExpression.translateGuardExpression(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (guardExpression == null) {
                    throw new InvalidCommandUseException("Invalid guard expression.");
                }
                GuardList guardList = this.simulator.getGuardList();
                try {
                    guardList.addGuard(guardExpression);
                }
                catch (Exception exception) {
                    throw new InvalidCommandUseException("Unable to add guard expression.");
                }
            }
            throw new InvalidCommandUseException("Incorrect use of ADD command.");
        }
        commandResultBuffer.append("* ADD DONE");
    }
}

