/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;

public class Utility {
    public static String sAsBinary(long l) {
        String string = "0";
        if (l != 0L) {
            string = Long.toBinaryString(l);
        }
        return string;
    }

    public static String sAsBinary(float f) {
        int n = Float.floatToIntBits(f);
        return Utility.sAsBinary(n);
    }

    public static String sAsBinary(double d) {
        long l = Double.doubleToLongBits(d);
        return Utility.sAsBinary(l);
    }

    public static String sAsBinaryPadded(long l, int n) {
        return Utility.sLeftPad(Utility.sAsBinary(l), n, '0');
    }

    public static String sAsBinaryPadded(float f, int n) {
        return Utility.sLeftPad(Utility.sAsBinary(f), n, '0');
    }

    public static String sAsBinaryPadded(double d, int n) {
        return Utility.sLeftPad(Utility.sAsBinary(d), n, '0');
    }

    public static String sAsHex(long l) {
        String string = "0";
        if (l != 0L) {
            string = Long.toHexString(l);
        }
        return string;
    }

    public static String sAsHex(float f) {
        int n = Float.floatToIntBits(f);
        return Utility.sAsHex(n);
    }

    public static String sAsHex(double d) {
        long l = Double.doubleToLongBits(d);
        return Utility.sAsHex(l);
    }

    public static String sAsHexPadded(long l, int n) {
        return Utility.sLeftPad(Utility.sAsHex(l), n, '0');
    }

    public static String sAsHexPadded(double d, int n) {
        return Utility.sLeftPad(Utility.sAsHex(d), n, '0');
    }

    public static String sAsHexPadded(float f, int n) {
        return Utility.sLeftPad(Utility.sAsHex(f), n, '0');
    }

    public static String sPad(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String sLeftPad(String string, int n, char c) {
        if (string.length() > n) {
            return string.substring(string.length() - n);
        }
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > 0) {
            stringBuffer.append(c);
            --n2;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static long IntegerLiteralToLong(String string) {
        long l = 0L;
        l = (string = string.toUpperCase()).startsWith("0X") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string, 10);
        return l;
    }

    public static double FloatingPointLiteralToDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("Error converting '" + string + "' to double: " + exception);
        }
        return d;
    }

    public static float FloatingPointLiteralToFloat(String string) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            System.out.println("Error converting '" + string + "' to float: " + exception);
        }
        return f;
    }

    public static String sRemoveChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == c) {
                stringBuffer.deleteCharAt(n);
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public static Vector vLoadFileAsVector(String string) {
        Vector<String> vector = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            return vector;
        }
        vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2);
            }
        }
        catch (Exception exception) {
            vector = null;
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public static int iSetBit(int n, int n2, boolean bl) {
        int n3 = n;
        if (n2 < 0 || n2 > 31) {
            return n3;
        }
        int n4 = 1 << n2;
        n3 = bl ? n | n4 : n & (n4 ^= 0xFFFFFFFF);
        return n3;
    }

    public static boolean bBitSet(int n, int n2, boolean bl) {
        boolean bl2 = false;
        if (n2 < 0 || n2 > 31) {
            return bl2;
        }
        int n3 = 1 << n2;
        bl2 = bl ? (n & n3) > 0 : (n & n3) == 0;
        return bl2;
    }

    public static int iHexStrToInt(String string) {
        long l = Long.parseLong(string, 16);
        int n = (int)(l & 0xFFFFFFFFL);
        return n;
    }
}

