/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.AlphaMemoryBucket;
import JIMSCore.Utility;
import java.util.Vector;

public class MainMemory {
    public static final int DEFAULT_TEXT_ADDRESS = 0x400000;
    public static final int DEFAULT_DATA_ADDRESS = 0x10000000;
    public static final int DEFAULT_STACK_ADDRESS = Integer.MAX_VALUE;
    public static final int DEFAULT_EXCEPTION_ADDRESS = -2147483264;
    public static final int NUM_BUCKETS = 256;
    private AlphaMemoryBucket[] memoryBucket;

    public MainMemory() {
        this.reset();
    }

    public void reset() {
        if (this.memoryBucket != null) {
            int n = 0;
            while (n < this.memoryBucket.length) {
                if (this.memoryBucket[n] != null) {
                    this.memoryBucket[n].reset();
                    this.memoryBucket[n] = null;
                }
                ++n;
            }
        }
        this.memoryBucket = new AlphaMemoryBucket[256];
    }

    public void storeByte(int n, byte by) {
        int n2 = (n & 0xFF000000) >>> 24;
        if (this.memoryBucket[n2] == null) {
            this.memoryBucket[n2] = new AlphaMemoryBucket();
        }
        int n3 = (n & 0xFF0000) >>> 16;
        int n4 = (n & 0xFF00) >>> 8;
        int n5 = n & 0xFF;
        this.memoryBucket[n2].storeByte(n3, n4, n5, by);
    }

    public void storeHalfWord(int n, int n2) {
        byte by = (byte)(((long)n2 & 0xFF00L) >>> 8);
        byte by2 = (byte)((long)n2 & 0xFFL);
        this.storeByte(n, by);
        this.storeByte(++n, by2);
    }

    public void storeWord(int n, int n2) {
        byte by = (byte)(((long)n2 & 0xFF000000L) >>> 24);
        byte by2 = (byte)(((long)n2 & 0xFF0000L) >>> 16);
        byte by3 = (byte)(((long)n2 & 0xFF00L) >>> 8);
        byte by4 = (byte)((long)n2 & 0xFFL);
        this.storeByte(n, by);
        this.storeByte(++n, by2);
        this.storeByte(++n, by3);
        this.storeByte(++n, by4);
    }

    public byte loadByte(int n) {
        int n2 = (n & 0xFF000000) >>> 24;
        if (this.memoryBucket == null || this.memoryBucket[n2] == null) {
            return 0;
        }
        int n3 = (n & 0xFF0000) >>> 16;
        int n4 = (n & 0xFF00) >>> 8;
        int n5 = n & 0xFF;
        return this.memoryBucket[n2].loadByte(n3, n4, n5);
    }

    public int loadHalfWord(int n) {
        int n2 = this.loadByte(n) << 8 & 0xFF00;
        int n3 = this.loadByte(n + 1) & 0xFF;
        return n2 | n3;
    }

    public int loadWord(int n) {
        int n2 = this.loadByte(n) << 24 & 0xFF000000;
        int n3 = this.loadByte(++n) << 16 & 0xFF0000;
        int n4 = this.loadByte(++n) << 8 & 0xFF00;
        int n5 = this.loadByte(++n) & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public Vector vGetModifiedAddresses() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.memoryBucket != null) {
            int n = 0;
            while (n < this.memoryBucket.length) {
                if (this.memoryBucket[n] != null && this.memoryBucket[n].memoryBucket != null) {
                    int n2 = 0;
                    while (n2 < this.memoryBucket[n].memoryBucket.length) {
                        if (this.memoryBucket[n].memoryBucket[n2] != null && this.memoryBucket[n].memoryBucket[n2].memoryBucket != null) {
                            int n3 = 0;
                            while (n3 < this.memoryBucket[n].memoryBucket[n2].memoryBucket.length) {
                                if (this.memoryBucket[n].memoryBucket[n2].memoryBucket[n3] != null) {
                                    int n4 = 0;
                                    while (n4 < this.memoryBucket[n].memoryBucket[n2].memoryBucket[n3].cell.length) {
                                        if (this.memoryBucket[n].memoryBucket[n2].memoryBucket[n3].modified[n4] > 0) {
                                            int n5 = n << 24;
                                            int n6 = n2 << 16;
                                            int n7 = n3 << 8;
                                            int n8 = n5 | n6 | n7 | n4;
                                            vector.add(new Integer(n8));
                                        }
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public StringBuffer sbGetMemoryDump(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.memoryBucket != null) {
            int n = 0;
            while (n < this.memoryBucket.length) {
                if (this.memoryBucket[n] != null) {
                    stringBuffer.append((Object)this.memoryBucket[n].sbGetMemoryDump(string + Utility.sAsHexPadded(n, 2)));
                }
                ++n;
            }
        }
        return stringBuffer;
    }

    public String toString() {
        return this.sbGetMemoryDump("$").toString();
    }
}

