/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.InstructionDecodeBuffer;
import JIMSCore.Simulator;
import JIMSCore.State;
import JIMSCore.StateHistoryBuffer;
import JIMSCore.Utility;

public class InstructionExecuter {
    public static final int SC_PRINT_INT = 1;
    public static final int SC_PRINT_FLOAT = 2;
    public static final int SC_PRINT_DOUBLE = 3;
    public static final int SC_PRINT_STRING = 4;
    public static final int SC_READ_INT = 5;
    public static final int SC_READ_FLOAT = 6;
    public static final int SC_READ_DOUBLE = 7;
    public static final int SC_READ_STRING = 8;
    public static final int SC_SBRK = 9;
    public static final int SC_EXIT = 10;
    public static final int OP_MULTI_1 = 0;
    public static final int OP_MULTI_2 = 1;
    public static final int OP_J = 2;
    public static final int OP_JAL = 3;
    public static final int OP_BEQ = 4;
    public static final int OP_BNE = 5;
    public static final int OP_BLEZ = 6;
    public static final int OP_BGTZ = 7;
    public static final int OP_ADDI = 8;
    public static final int OP_ADDIU = 9;
    public static final int OP_SLTI = 10;
    public static final int OP_SLTIU = 11;
    public static final int OP_ANDI = 12;
    public static final int OP_ORI = 13;
    public static final int OP_XORI = 14;
    public static final int OP_LUI = 15;
    public static final int OP_MULTI_3 = 16;
    public static final int OP_MULTI_4 = 17;
    public static final int OP_MULTI_5 = 18;
    public static final int OP_MULTI_6 = 19;
    public static final int OP_LB = 32;
    public static final int OP_LH = 33;
    public static final int OP_LWL = 34;
    public static final int OP_LW = 35;
    public static final int OP_LBU = 36;
    public static final int OP_LHU = 37;
    public static final int OP_LWR = 38;
    public static final int OP_SB = 40;
    public static final int OP_SH = 41;
    public static final int OP_SWL = 42;
    public static final int OP_SW = 43;
    public static final int OP_SWR = 46;
    public static final int OP_LWC0 = 48;
    public static final int OP_LWC1 = 49;
    public static final int OP_LWC2 = 50;
    public static final int OP_LWC3 = 51;
    public static final int OP_SWC0 = 56;
    public static final int OP_SWC1 = 57;
    public static final int OP_SWC2 = 58;
    public static final int OP_SWC3 = 59;
    public static final int OP_SLL = 0;
    public static final int OP_SRL = 2;
    public static final int OP_SRA = 3;
    public static final int OP_SLLV = 4;
    public static final int OP_SRLV = 6;
    public static final int OP_SRAV = 7;
    public static final int OP_JR = 8;
    public static final int OP_JALR = 9;
    public static final int OP_SYSCALL = 12;
    public static final int OP_BREAK = 13;
    public static final int OP_MFHI = 16;
    public static final int OP_MTHI = 17;
    public static final int OP_MFLO = 18;
    public static final int OP_MTLO = 19;
    public static final int OP_MULT = 24;
    public static final int OP_MULTU = 25;
    public static final int OP_DIV = 26;
    public static final int OP_DIVU = 27;
    public static final int OP_ADD = 32;
    public static final int OP_ADDU = 33;
    public static final int OP_SUB = 34;
    public static final int OP_SUBU = 35;
    public static final int OP_AND = 36;
    public static final int OP_OR = 37;
    public static final int OP_XOR = 38;
    public static final int OP_NOR = 39;
    public static final int OP_SLT = 42;
    public static final int OP_SLTU = 43;
    public static final int OP_BLTZ = 0;
    public static final int OP_BGEZ = 1;
    public static final int OP_BLTZAL = 16;
    public static final int OP_BGEZAL = 17;
    public static final int OP_MFCZ = 0;
    public static final int OP_CFCZ = 2;
    public static final int OP_MTCZ = 4;
    public static final int OP_CTCZ = 6;
    public static final int OP_MULTI_7 = 8;
    public static final int OP_COPZ_1 = 16;
    public static final int OP_COPZ_2 = 17;
    public static final int OP_TLBR = 1;
    public static final int OP_TLBWL = 2;
    public static final int OP_TLBWR = 6;
    public static final int OP_TLBP = 8;
    public static final int OP_RFE = 16;
    public static final int OP_ADD_F = 0;
    public static final int OP_SUB_F = 1;
    public static final int OP_MUL_F = 2;
    public static final int OP_DIV_F = 3;
    public static final int OP_ABS_F = 5;
    public static final int OP_MOV_F = 6;
    public static final int OP_NEG_F = 7;
    public static final int OP_CVT_S_F = 32;
    public static final int OP_CVT_D_F = 33;
    public static final int OP_CVT_W_F = 36;
    public static final int OP_C_F_F = 48;
    public static final int OP_C_UN_F = 49;
    public static final int OP_C_EQ_F = 50;
    public static final int OP_C_UEQ_F = 51;
    public static final int OP_C_OLT_F = 52;
    public static final int OP_C_ULT_F = 53;
    public static final int OP_C_OLE_F = 54;
    public static final int OP_C_ULE_F = 55;
    public static final int OP_C_ST_F = 56;
    public static final int OP_C_NGLE_F = 57;
    public static final int OP_C_SEQ_F = 58;
    public static final int OP_C_NGL_F = 59;
    public static final int OP_C_LT_F = 60;
    public static final int OP_C_NGE_F = 61;
    public static final int OP_C_LE_F = 62;
    public static final int OP_C_NGT_F = 63;
    public static final int FP_S = 0;
    public static final int FP_D = 1;
    public static final int UNDEFINED_DIVIDE = 0;
    private Simulator simulator;
    private State state;
    private StateHistoryBuffer stateHistoryBuffer;
    private boolean bInvalidOpcodeDetected;
    private int iExecuteResult;
    private static final int ERR_NONE = 0;
    private static final int ERR_INVALID_OPCODE = 1;
    private static final int ERR_FP_HARDWARE_REQUIRED = 2;
    private static final int ERR_SYSCALL = 3;
    private static final int ERR_BREAK = 4;
    private static final int ERR_OVERFLOW = 5;
    private static final int ERR_FP_EXCEPTION = 6;

    public InstructionExecuter(StateHistoryBuffer stateHistoryBuffer, Simulator simulator) {
        this.simulator = simulator;
        this.state = simulator.getState();
        this.stateHistoryBuffer = stateHistoryBuffer;
    }

    public void status(String string) {
        System.out.println(string);
    }

    private void unknownOpcode() {
        this.status("UNKOWN OPCODE");
        this.iExecuteResult = 1;
    }

    public int iExecute(InstructionDecodeBuffer instructionDecodeBuffer) {
        int n = -3;
        this.iExecuteResult = 0;
        try {
            this.execute(instructionDecodeBuffer);
        }
        catch (Exception exception) {
            System.err.println("INTERNAL ERROR: " + exception);
            return -1;
        }
        switch (this.iExecuteResult) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = -2;
                break;
            }
            case 2: {
                n = -4;
                break;
            }
            case 3: {
                n = -5;
                break;
            }
            case 4: {
                n = -6;
                break;
            }
            case 5: {
                n = -7;
                break;
            }
            case 6: {
                n = -8;
                break;
            }
            default: {
                System.err.println("EXECUTE ERROR: " + this.iExecuteResult);
                n = -3;
            }
        }
        return n;
    }

    private void execute(InstructionDecodeBuffer instructionDecodeBuffer) {
        this.bInvalidOpcodeDetected = false;
        switch (instructionDecodeBuffer.opcode) {
            case 0: {
                this.executeMulti1Instruction(instructionDecodeBuffer);
                break;
            }
            case 1: {
                this.executeMulti2Instruction(instructionDecodeBuffer);
                break;
            }
            case 2: {
                int n = instructionDecodeBuffer.target * 4;
                this.state.setRegister(32, n);
                break;
            }
            case 3: {
                int n = this.state.iGetRegister(32);
                int n2 = instructionDecodeBuffer.target * 4;
                this.state.setRegister(31, n);
                this.state.setRegister(32, n2);
                break;
            }
            case 4: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n3 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                if (n != n3) break;
                int n4 = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n4 += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 5: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n5 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                if (n == n5) break;
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 6: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n > 0) break;
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 7: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n <= 0) break;
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 8: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                short s = (short)instructionDecodeBuffer.imm;
                int n6 = n + s;
                if (n >= 0 & s >= 0 & n6 < 0 | n < 0 & s < 0 & n6 >= 0) {
                    this.iExecuteResult = 5;
                    break;
                }
                this.state.setRegister(instructionDecodeBuffer.rt, n6);
                break;
            }
            case 9: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                short s = (short)instructionDecodeBuffer.imm;
                int n7 = n + s;
                this.state.setRegister(instructionDecodeBuffer.rt, n7);
                break;
            }
            case 10: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n8 = 0;
                if (n < (short)instructionDecodeBuffer.imm) {
                    n8 = 1;
                }
                this.state.setRegister(instructionDecodeBuffer.rt, n8);
                break;
            }
            case 11: {
                long l = (long)this.state.iGetRegister(instructionDecodeBuffer.rs) & 0xFFFFFFFFL;
                long l2 = (long)instructionDecodeBuffer.imm & 0xFFFFFFFFL;
                int n = 0;
                if (l < l2) {
                    n = 1;
                }
                this.state.setRegister(instructionDecodeBuffer.rt, n);
                break;
            }
            case 12: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n9 = n & instructionDecodeBuffer.imm;
                this.state.setRegister(instructionDecodeBuffer.rt, n9);
                break;
            }
            case 13: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n10 = n | instructionDecodeBuffer.imm;
                this.state.setRegister(instructionDecodeBuffer.rt, n10);
                break;
            }
            case 14: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n11 = n ^ instructionDecodeBuffer.imm;
                this.state.setRegister(instructionDecodeBuffer.rt, n11);
                break;
            }
            case 15: {
                int n = instructionDecodeBuffer.imm << 16;
                int n12 = n & 0xFFFF0000;
                this.state.setRegister(instructionDecodeBuffer.rt, n12);
                break;
            }
            case 16: {
                this.executeMultiZInstruction(instructionDecodeBuffer, 0);
                break;
            }
            case 17: {
                this.executeMultiZInstruction(instructionDecodeBuffer, 1);
                break;
            }
            case 18: {
                this.executeMultiZInstruction(instructionDecodeBuffer, 2);
                break;
            }
            case 19: {
                this.executeMultiZInstruction(instructionDecodeBuffer, 3);
                break;
            }
            case 32: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                byte by = this.state.loadByte(instructionDecodeBuffer.offset + n);
                this.state.setRegister(instructionDecodeBuffer.rt, by);
                break;
            }
            case 33: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n13 = this.state.loadHalfWord(instructionDecodeBuffer.offset + n);
                this.state.setRegister(instructionDecodeBuffer.rt, n13);
                break;
            }
            case 34: {
                int n = instructionDecodeBuffer.offset + this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n14 = 24;
                int n15 = 0;
                while (true) {
                    int n16 = (this.state.loadByte(n) & 0xFF) << n14;
                    n15 |= n16;
                    if ((n & 3) == 0) break;
                    --n;
                    n14 -= 8;
                }
                this.state.setRegister(instructionDecodeBuffer.rt, n15);
                break;
            }
            case 35: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n17 = this.state.loadWord(instructionDecodeBuffer.offset + n);
                this.state.setRegister(instructionDecodeBuffer.rt, n17);
                break;
            }
            case 36: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n18 = this.state.loadByte(instructionDecodeBuffer.offset + n) & 0xFF;
                this.state.setRegister(instructionDecodeBuffer.rt, n18);
                break;
            }
            case 37: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n19 = this.state.loadHalfWord(instructionDecodeBuffer.offset + n) & 0xFFFF;
                this.state.setRegister(instructionDecodeBuffer.rt, n19);
                break;
            }
            case 38: {
                int n = instructionDecodeBuffer.offset + this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n20 = 0;
                int n21 = 0;
                while (true) {
                    int n22 = (this.state.loadByte(n) & 0xFF) << n20;
                    n21 |= n22;
                    if ((n & 3) == 0) break;
                    ++n;
                    n20 += 8;
                }
                this.state.setRegister(instructionDecodeBuffer.rt, n21);
                break;
            }
            case 40: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                byte by = (byte)(this.state.iGetRegister(instructionDecodeBuffer.rt) & 0xFF);
                n = instructionDecodeBuffer.offset + n;
                this.state.storeByte(n, by);
                break;
            }
            case 41: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n23 = this.state.iGetRegister(instructionDecodeBuffer.rt) & 0xFFFF;
                n = instructionDecodeBuffer.offset + n;
                this.state.storeHalfWord(n, n23);
                break;
            }
            case 43: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n24 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                n = instructionDecodeBuffer.offset + n;
                this.state.storeWord(n, n24);
                break;
            }
            case 48: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n25 = this.state.loadWord(instructionDecodeBuffer.offset + n);
                this.state.setCP0Register(instructionDecodeBuffer.rt, n25);
                break;
            }
            case 49: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n26 = this.state.loadWord(instructionDecodeBuffer.offset + n);
                this.state.setCP1Register(instructionDecodeBuffer.rt, n26);
                break;
            }
            case 56: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n27 = this.state.iGetCP0Register(instructionDecodeBuffer.rt);
                n = instructionDecodeBuffer.offset + n;
                this.state.storeWord(n, n27);
                break;
            }
            case 57: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n28 = this.state.iGetCP1Register(instructionDecodeBuffer.rt);
                n = instructionDecodeBuffer.offset + n;
                this.state.storeWord(n, n28);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeMulti1Instruction(InstructionDecodeBuffer instructionDecodeBuffer) {
        switch (instructionDecodeBuffer.funct) {
            case 0: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                this.state.setRegister(instructionDecodeBuffer.rd, n <<= instructionDecodeBuffer.shamt);
                break;
            }
            case 2: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                this.state.setRegister(instructionDecodeBuffer.rd, n >>= instructionDecodeBuffer.shamt);
                break;
            }
            case 3: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                this.state.setRegister(instructionDecodeBuffer.rd, n >>>= instructionDecodeBuffer.shamt);
                break;
            }
            case 4: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n2 = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(instructionDecodeBuffer.rd, n <<= n2);
                break;
            }
            case 6: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n3 = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(instructionDecodeBuffer.rd, n >>= n3);
                break;
            }
            case 7: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n4 = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(instructionDecodeBuffer.rd, n >>>= n4);
                break;
            }
            case 8: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(32, n);
                break;
            }
            case 9: {
                int n = this.state.iGetRegister(32);
                this.state.setRegister(instructionDecodeBuffer.rd, n);
                int n5 = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(32, n5);
                break;
            }
            case 12: {
                int n = this.state.iGetRegister(2);
                this.performSystemCall(n);
                break;
            }
            case 13: {
                this.iExecuteResult = 4;
                break;
            }
            case 16: {
                int n = this.state.iGetRegister(33);
                this.state.setRegister(instructionDecodeBuffer.rd, n);
                break;
            }
            case 17: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(33, n);
                break;
            }
            case 18: {
                int n = this.state.iGetRegister(34);
                this.state.setRegister(instructionDecodeBuffer.rd, n);
                break;
            }
            case 19: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                this.state.setRegister(34, n);
                break;
            }
            case 24: {
                long l = this.state.iGetRegister(instructionDecodeBuffer.rs);
                long l2 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n = (int)(((l *= l2) & 0xFFFFFFFF00000000L) >>> 32);
                int n6 = (int)(l & 0xFFFFFFFFL);
                this.state.setRegister(33, n);
                this.state.setRegister(34, n6);
                break;
            }
            case 25: {
                long l = (long)this.state.iGetRegister(instructionDecodeBuffer.rs) & 0xFFFFFFFFL;
                long l3 = (long)this.state.iGetRegister(instructionDecodeBuffer.rt) & 0xFFFFFFFFL;
                int n = (int)(((l *= l3) & 0xFFFFFFFF00000000L) >>> 32);
                int n7 = (int)(l & 0xFFFFFFFFL);
                this.state.setRegister(33, n);
                this.state.setRegister(34, n7);
                break;
            }
            case 26: {
                long l = this.state.iGetRegister(instructionDecodeBuffer.rs);
                long l4 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                if (l4 == 0L) break;
                this.state.setRegister(34, (int)(l / l4));
                this.state.setRegister(33, (int)(l % l4));
                break;
            }
            case 27: {
                long l = (long)this.state.iGetRegister(instructionDecodeBuffer.rs) & 0xFFFFFFFFL;
                long l5 = (long)this.state.iGetRegister(instructionDecodeBuffer.rt) & 0xFFFFFFFFL;
                if (l5 == 0L) break;
                this.state.setRegister(34, (int)(l / l5));
                this.state.setRegister(33, (int)(l % l5));
                break;
            }
            case 32: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n8 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n9 = n + n8;
                if (n >= 0 & n8 >= 0 & n9 < 0 | n < 0 & n8 < 0 & n9 >= 0) {
                    this.iExecuteResult = 5;
                    break;
                }
                this.state.setRegister(instructionDecodeBuffer.rd, n9);
                break;
            }
            case 33: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n10 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n11 = n + n10;
                this.state.setRegister(instructionDecodeBuffer.rd, n11);
                break;
            }
            case 34: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n12 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n13 = n - n12;
                if (n >= 0 & n12 < 0 & n13 < 0 | n < 0 & n12 >= 0 & n13 >= 0) {
                    this.iExecuteResult = 5;
                    break;
                }
                this.state.setRegister(instructionDecodeBuffer.rd, n13);
                break;
            }
            case 35: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n14 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n15 = n - n14;
                this.state.setRegister(instructionDecodeBuffer.rd, n15);
                break;
            }
            case 36: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n16 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n17 = n & n16;
                this.state.setRegister(instructionDecodeBuffer.rd, n17);
                break;
            }
            case 37: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n18 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n19 = n | n18;
                this.state.setRegister(instructionDecodeBuffer.rd, n19);
                break;
            }
            case 38: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n20 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n21 = n ^ n20;
                this.state.setRegister(instructionDecodeBuffer.rd, n21);
                break;
            }
            case 39: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                int n22 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n23 = ~(n | n22);
                this.state.setRegister(instructionDecodeBuffer.rd, n23);
                break;
            }
            case 42: {
                long l = this.state.iGetRegister(instructionDecodeBuffer.rs);
                long l6 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                int n = 0;
                if (l < l6) {
                    n = 1;
                }
                this.state.setRegister(instructionDecodeBuffer.rd, n);
                break;
            }
            case 43: {
                long l = (long)this.state.iGetRegister(instructionDecodeBuffer.rs) & 0xFFFFFFFFL;
                long l7 = (long)this.state.iGetRegister(instructionDecodeBuffer.rt) & 0xFFFFFFFFL;
                int n = 0;
                if (l < l7) {
                    n = 1;
                }
                this.state.setRegister(instructionDecodeBuffer.rd, n);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeMulti2Instruction(InstructionDecodeBuffer instructionDecodeBuffer) {
        switch (instructionDecodeBuffer.rt) {
            case 0: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n >= 0) break;
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 1: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n < 0) break;
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 16: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n >= 0) break;
                n = this.state.iGetRegister(32);
                this.state.setRegister(31, n);
                n = this.state.iGetRegister(32) - 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            case 17: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.rs);
                if (n < 0) break;
                n = this.state.iGetRegister(32);
                this.state.setRegister(31, n);
                n -= 4;
                this.state.setRegister(32, n += instructionDecodeBuffer.offset * 4);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeMultiZInstruction(InstructionDecodeBuffer instructionDecodeBuffer, int n) {
        block0 : switch (instructionDecodeBuffer.rs) {
            case 0: {
                switch (n) {
                    case 0: {
                        int n2 = this.state.iGetCP0Register(instructionDecodeBuffer.rt);
                        this.state.setRegister(instructionDecodeBuffer.rd, n2);
                        break block0;
                    }
                    case 1: {
                        int n3 = this.state.iGetCP1Register(instructionDecodeBuffer.rt);
                        this.state.setRegister(instructionDecodeBuffer.rd, n3);
                        break block0;
                    }
                }
                this.unknownOpcode();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        int n4 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                        this.state.setCP0Register(instructionDecodeBuffer.rd, n4);
                        break block0;
                    }
                    case 1: {
                        int n5 = this.state.iGetRegister(instructionDecodeBuffer.rt);
                        this.state.setCP1Register(instructionDecodeBuffer.rd, n5);
                        break block0;
                    }
                }
                this.unknownOpcode();
                break;
            }
            case 8: {
                if (Utility.bBitSet(instructionDecodeBuffer.rawInstruction, 16, false)) {
                    switch (n) {
                        case 1: {
                            int n6 = this.state.iGetCP1Register(33);
                            if (!Utility.bBitSet(n6, 23, false)) break block0;
                            int n7 = this.state.iGetRegister(32) - 4;
                            this.state.setRegister(32, n7 += instructionDecodeBuffer.offset * 4);
                            break;
                        }
                        default: {
                            this.unknownOpcode();
                            break;
                        }
                    }
                    break;
                }
                switch (n) {
                    case 1: {
                        int n8 = this.state.iGetCP1Register(33);
                        if (!Utility.bBitSet(n8, 23, true)) break block0;
                        int n9 = this.state.iGetRegister(32) - 4;
                        this.state.setRegister(32, n9 += instructionDecodeBuffer.offset * 4);
                        break;
                    }
                    default: {
                        this.unknownOpcode();
                        break;
                    }
                }
                break;
            }
            case 16: {
                switch (n) {
                    case 0: {
                        this.executeMiscInstruction(instructionDecodeBuffer);
                        break;
                    }
                    case 1: {
                        this.executeFPInstruction(instructionDecodeBuffer, 0);
                    }
                }
                break;
            }
            case 17: {
                switch (n) {
                    case 1: {
                        this.executeFPInstruction(instructionDecodeBuffer, 1);
                        break block0;
                    }
                }
                this.unknownOpcode();
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeMiscInstruction(InstructionDecodeBuffer instructionDecodeBuffer) {
        switch (instructionDecodeBuffer.funct) {
            default: 
        }
        this.unknownOpcode();
    }

    private void executeFPInstruction(InstructionDecodeBuffer instructionDecodeBuffer, int n) {
        if (!this.simulator.bHasFPA()) {
            this.iExecuteResult = 2;
            return;
        }
        switch (n) {
            case 0: {
                this.executeFPSInstruction(instructionDecodeBuffer);
                break;
            }
            case 1: {
                this.executeFPDInstruction(instructionDecodeBuffer);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeFPSInstruction(InstructionDecodeBuffer instructionDecodeBuffer) {
        float f = 0.0f;
        switch (instructionDecodeBuffer.funct) {
            case 0: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n2 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f2 = Float.intBitsToFloat(n);
                float f3 = Float.intBitsToFloat(n2);
                f = f2 + f3;
                int n3 = Float.floatToIntBits(f);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n3);
                break;
            }
            case 1: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n4 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f4 = Float.intBitsToFloat(n);
                float f5 = Float.intBitsToFloat(n4);
                f = f4 - f5;
                int n5 = Float.floatToIntBits(f);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n5);
                break;
            }
            case 2: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n6 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f6 = Float.intBitsToFloat(n);
                float f7 = Float.intBitsToFloat(n6);
                f = f6 * f7;
                int n7 = Float.floatToIntBits(f);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n7);
                break;
            }
            case 3: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n8 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f8 = Float.intBitsToFloat(n);
                float f9 = Float.intBitsToFloat(n8);
                if ((double)f9 == 0.0) {
                    this.iExecuteResult = 6;
                    break;
                }
                f = f8 / f9;
                int n9 = Float.floatToIntBits(f);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n9);
                break;
            }
            case 5: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                float f10 = Float.intBitsToFloat(n);
                float f11 = Math.abs(f10);
                int n10 = Float.floatToIntBits(f11);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n10);
                break;
            }
            case 6: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n);
                break;
            }
            case 7: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                float f12 = Float.intBitsToFloat(n);
                float f13 = -f12;
                int n11 = Float.floatToIntBits(f13);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n11);
                break;
            }
            case 32: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.fs);
                float f14 = n;
                int n12 = Float.floatToIntBits(f14);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n12);
                break;
            }
            case 33: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.fs);
                float f15 = Float.intBitsToFloat(n);
                double d = f15;
                long l = Double.doubleToLongBits(d);
                n = (int)((l & 0xFFFFFFFF00000000L) >>> 32);
                int n13 = (int)(l & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n13);
                break;
            }
            case 36: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                float f16 = Float.intBitsToFloat(n);
                n = (int)f16;
                this.state.setRegister(instructionDecodeBuffer.fd, n);
                break;
            }
            case 50: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n14 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f17 = Float.intBitsToFloat(n);
                float f18 = Float.intBitsToFloat(n14);
                n = this.state.iGetCP1Register(33);
                n = f18 == f17 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            case 51: 
            case 60: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n15 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f19 = Float.intBitsToFloat(n);
                float f20 = Float.intBitsToFloat(n15);
                n = this.state.iGetCP1Register(33);
                n = f19 < f20 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            case 62: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n16 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                float f21 = Float.intBitsToFloat(n);
                float f22 = Float.intBitsToFloat(n16);
                n = this.state.iGetCP1Register(33);
                n = f21 <= f22 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void executeFPDInstruction(InstructionDecodeBuffer instructionDecodeBuffer) {
        double d = 0.0;
        switch (instructionDecodeBuffer.funct) {
            case 0: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n2 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n2 << 32;
                double d2 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n3 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n4 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l2 = (long)n4 << 32;
                double d3 = Double.longBitsToDouble(l2 |= (long)n3 & 0xFFFFFFFFL);
                d = d2 + d3;
                long l3 = Double.doubleToLongBits(d);
                n = (int)((l3 & 0xFFFFFFFF00000000L) >>> 32);
                n2 = (int)(l3 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n2);
                break;
            }
            case 1: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n5 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n5 << 32;
                double d4 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n6 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n7 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l4 = (long)n7 << 32;
                double d5 = Double.longBitsToDouble(l4 |= (long)n6 & 0xFFFFFFFFL);
                d = d4 - d5;
                long l5 = Double.doubleToLongBits(d);
                n = (int)((l5 & 0xFFFFFFFF00000000L) >>> 32);
                n5 = (int)(l5 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n5);
                break;
            }
            case 2: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n8 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n8 << 32;
                double d6 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n9 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n10 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l6 = (long)n10 << 32;
                double d7 = Double.longBitsToDouble(l6 |= (long)n9 & 0xFFFFFFFFL);
                d = d6 * d7;
                long l7 = Double.doubleToLongBits(d);
                n = (int)((l7 & 0xFFFFFFFF00000000L) >>> 32);
                n8 = (int)(l7 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n8);
                break;
            }
            case 3: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n11 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n11 << 32;
                double d8 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n12 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n13 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l8 = (long)n13 << 32;
                double d9 = Double.longBitsToDouble(l8 |= (long)n12 & 0xFFFFFFFFL);
                if (d9 == 0.0) {
                    this.iExecuteResult = 6;
                    break;
                }
                d = d8 / d9;
                long l9 = Double.doubleToLongBits(d);
                n = (int)((l9 & 0xFFFFFFFF00000000L) >>> 32);
                n11 = (int)(l9 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n11);
                break;
            }
            case 5: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n14 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n14 << 32;
                double d10 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                double d11 = Math.abs(d10);
                long l10 = Double.doubleToLongBits(d11);
                n = (int)((l10 & 0xFFFFFFFF00000000L) >>> 32);
                n14 = (int)(l10 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n14);
                break;
            }
            case 6: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n15 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n15);
                break;
            }
            case 7: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n16 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n16 << 32;
                double d12 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                double d13 = -d12;
                long l11 = Double.doubleToLongBits(d13);
                n = (int)((l11 & 0xFFFFFFFF00000000L) >>> 32);
                n16 = (int)(l11 & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n16);
                break;
            }
            case 32: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n17 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n17 << 32;
                double d14 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                float f = (float)d14;
                n = Float.floatToIntBits(f);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n);
                break;
            }
            case 33: {
                int n = this.state.iGetRegister(instructionDecodeBuffer.fs);
                double d15 = n;
                long l = Double.doubleToLongBits(d15);
                n = (int)((l & 0xFFFFFFFF00000000L) >>> 32);
                int n18 = (int)(l & 0xFFFFFFFFL);
                this.state.setCP1Register(instructionDecodeBuffer.fd + 1, n);
                this.state.setCP1Register(instructionDecodeBuffer.fd, n18);
                break;
            }
            case 36: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n19 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n19 << 32;
                double d16 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                n = (int)d16;
                this.state.setRegister(instructionDecodeBuffer.fd, n);
                break;
            }
            case 50: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n20 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n20 << 32;
                double d17 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n21 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n22 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l12 = (long)n22 << 32;
                double d18 = Double.longBitsToDouble(l12 |= (long)n21 & 0xFFFFFFFFL);
                n = this.state.iGetCP1Register(33);
                n = d18 == d17 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            case 60: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n23 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n23 << 32;
                double d19 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n24 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n25 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l13 = (long)n25 << 32;
                double d20 = Double.longBitsToDouble(l13 |= (long)n24 & 0xFFFFFFFFL);
                n = this.state.iGetCP1Register(33);
                n = d20 < d19 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            case 62: {
                int n = this.state.iGetCP1Register(instructionDecodeBuffer.fs);
                int n26 = this.state.iGetCP1Register(instructionDecodeBuffer.fs + 1);
                long l = (long)n26 << 32;
                double d21 = Double.longBitsToDouble(l |= (long)n & 0xFFFFFFFFL);
                int n27 = this.state.iGetCP1Register(instructionDecodeBuffer.ft);
                int n28 = this.state.iGetCP1Register(instructionDecodeBuffer.ft + 1);
                long l14 = (long)n28 << 32;
                double d22 = Double.longBitsToDouble(l14 |= (long)n27 & 0xFFFFFFFFL);
                n = this.state.iGetCP1Register(33);
                n = d21 <= d22 ? Utility.iSetBit(n, 23, true) : Utility.iSetBit(n, 23, false);
                this.state.setCP1Register(33, n);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }

    private void performSystemCall(int n) {
        String string = "";
        this.iExecuteResult = 3;
        switch (n) {
            case 1: {
                this.state.setFlag(0, true);
                break;
            }
            case 2: {
                this.state.setFlag(1, true);
                break;
            }
            case 3: {
                this.state.setFlag(2, true);
                break;
            }
            case 4: {
                this.state.setFlag(3, true);
                break;
            }
            case 5: {
                this.state.setFlag(4, true);
                break;
            }
            case 6: {
                this.state.setFlag(5, true);
                break;
            }
            case 7: {
                this.state.setFlag(6, true);
                break;
            }
            case 8: {
                this.state.setFlag(7, true);
                break;
            }
            case 10: {
                this.state.setFlag(9, true);
                break;
            }
            default: {
                this.unknownOpcode();
            }
        }
    }
}

