/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import JIMSCore.State;
import java.util.StringTokenizer;

public class CommandSet
extends Command {
    private Simulator simulator;

    public CommandSet(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        State state = this.simulator.getState();
        String string = this.nextToken();
        if (string.startsWith("M")) {
            string = this.nextToken();
            int[] nArray = Command.iaGetMemoryRangeOrValue(string);
            if (nArray == null) {
                throw new InvalidCommandUseException("Invalid range or value specified.");
            }
            string = this.nextToken();
            int n = 0;
            try {
                n = Command.iGetNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidCommandUseException("Invalid memory value specified.");
            }
            if (n < -128 || n > 255) {
                throw new InvalidCommandUseException("Memory value must be 8-bit number.");
            }
            int n2 = nArray[0];
            while (n2 <= nArray[1]) {
                state.storeByte(n2, (byte)n);
                ++n2;
            }
        } else if (string.startsWith("R")) {
            string = this.nextToken();
            String string2 = this.nextToken();
            String string3 = this.nextToken();
            try {
                int[] nArray = null;
                if (string.equals("GPR")) {
                    nArray = Command.iaGetRegisterRangeOrValue(string2, 0);
                    int n = 0;
                    n = Command.iGetNumber(string3);
                    int n3 = nArray[0];
                    while (n3 <= nArray[1]) {
                        state.setRegister(n3, n);
                        ++n3;
                    }
                }
                if (string.equals("CP0")) {
                    nArray = Command.iaGetRegisterRangeOrValue(string2, 1);
                    int n = 0;
                    n = Command.iGetNumber(string3);
                    int n4 = nArray[0];
                    while (n4 <= nArray[1]) {
                        state.setCP0Register(n4, n);
                        ++n4;
                    }
                }
                if (string.equals("CP1")) {
                    nArray = Command.iaGetRegisterRangeOrValue(string2, 2);
                    int n = 0;
                    n = Command.iGetNumber(string3);
                    int n5 = nArray[0];
                    while (n5 <= nArray[1]) {
                        state.setCP1Register(n5, n);
                        ++n5;
                    }
                }
                throw new InvalidCommandUseException("Invalid register set specified in SET command.");
            }
            catch (Exception exception) {
                throw new InvalidCommandUseException("Invalid range or value or incorrect use of SET command.");
            }
        } else {
            throw new InvalidCommandUseException("Invalid use of SET command.");
        }
        commandResultBuffer.append("* SET DONE");
    }
}

