/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import JIMSCore.State;
import JIMSCore.Utility;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandGet
extends Command {
    public static final String ERR_CRITICAL = "ERR_CRITICAL";
    private Simulator simulator;

    public CommandGet(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        block10: {
            State state = this.simulator.getState();
            try {
                String string = this.nextToken();
                if (string.startsWith("M")) {
                    string = this.nextToken();
                    if (string.equals("") || string.startsWith("M")) {
                        Vector vector = state.vGetModifiedAddresses();
                        if (vector != null && vector.size() > 0) {
                            int n;
                            Enumeration enumeration = vector.elements();
                            int n2 = n = ((Integer)enumeration.nextElement()).intValue();
                            StringBuffer stringBuffer = new StringBuffer("* GET MEMORY " + Utility.sAsHexPadded(n2, 8) + " ");
                            while (true) {
                                byte by = state.loadByte(n2);
                                stringBuffer.append(Utility.sAsHexPadded(by, 2) + " ");
                                if (!enumeration.hasMoreElements()) break;
                                n = (Integer)enumeration.nextElement();
                                if (n == ++n2) continue;
                                commandResultBuffer.append(stringBuffer.toString());
                                n2 = n;
                                stringBuffer = new StringBuffer("* GET MEMORY " + Utility.sAsHexPadded(n2, 8) + " ");
                            }
                            commandResultBuffer.append(stringBuffer.toString());
                        }
                    } else {
                        String string2 = this.sGetMemory(string, state);
                        if (string2.trim().equals("")) {
                            throw new InvalidCommandUseException("Invalid memory range or value specified.");
                        }
                        commandResultBuffer.append(string2);
                    }
                    break block10;
                }
                if (string.startsWith("R")) {
                    String string3 = this.sGetRegister(this.stSource, state);
                    if (string3.trim().equals("")) {
                        throw new InvalidCommandUseException("Invalid register range or value specified.");
                    }
                    commandResultBuffer.append(string3);
                    break block10;
                }
                throw new InvalidCommandUseException("Invalid use of GET command.");
            }
            catch (Exception exception) {
                commandResultBuffer.append("* GET ERR ERR_CRITICAL " + exception);
            }
        }
        commandResultBuffer.append("* GET DONE");
    }

    private String sGetMemory(String string, State state) {
        String string2 = "";
        String string3 = string;
        int[] nArray = null;
        if (string3.trim().equals("")) {
            nArray = new int[]{state.iGetRegister(32), nArray[0] + 40};
        } else {
            nArray = Command.iaGetMemoryRangeOrValue(string3);
            if (nArray == null) {
                return "";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l = (long)nArray[0] & 0xFFFFFFFFL;
        long l2 = (long)nArray[1] & 0xFFFFFFFFL;
        stringBuffer.append("* GET MEMORY " + Utility.sAsHexPadded(l, 8) + " ");
        long l3 = l;
        while (l3 <= l2) {
            byte by = state.loadByte((int)l3);
            stringBuffer.append(Utility.sAsHexPadded(by, 2) + " ");
            ++l3;
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    private String sGetRegister(StringTokenizer stringTokenizer, State state) {
        String string;
        block16: {
            int[] nArray;
            String string2;
            String string3;
            block17: {
                block15: {
                    string = "";
                    string3 = this.nextToken();
                    string2 = this.nextToken();
                    nArray = null;
                    if (!string3.equals("GPR")) break block15;
                    if (string2.trim().equals("")) {
                        nArray = new int[]{0, 34};
                    } else {
                        nArray = Command.iaGetRegisterRangeOrValue(string2, 0);
                        if (nArray == null) {
                            return "";
                        }
                    }
                    int n = nArray[0];
                    while (n <= nArray[1]) {
                        int n2 = state.iGetRegister(n);
                        string = string + "* GET REGISTER GPR " + Utility.sAsHexPadded(n, 2) + " " + Utility.sAsHexPadded(n2, 8);
                        if (n < nArray[1]) {
                            string = string + "\n";
                        }
                        ++n;
                    }
                    break block16;
                }
                if (!string3.equals("CP0")) break block17;
                if (string2.trim().equals("")) {
                    nArray = new int[]{0, 31};
                } else {
                    nArray = Command.iaGetRegisterRangeOrValue(string2, 1);
                    if (nArray == null) {
                        return "";
                    }
                }
                int n = nArray[0];
                while (n <= nArray[1]) {
                    int n3 = state.iGetCP0Register(n);
                    string = string + "* GET REGISTER CP0 " + Utility.sAsHexPadded(n, 2) + " " + Utility.sAsHexPadded(n3, 8);
                    if (n < nArray[1]) {
                        string = string + "\n";
                    }
                    ++n;
                }
                break block16;
            }
            if (!string3.equals("CP1")) break block16;
            if (string2.trim().equals("")) {
                nArray = new int[]{0, 33};
            } else {
                nArray = Command.iaGetRegisterRangeOrValue(string2, 2);
                if (nArray == null) {
                    return "";
                }
            }
            int n = nArray[0];
            while (n <= nArray[1]) {
                int n4 = state.iGetCP1Register(n);
                string = string + "* GET REGISTER CP1 " + Utility.sAsHexPadded(n, 2) + " " + Utility.sAsHexPadded(n4, 8);
                if (n < nArray[1]) {
                    string = string + "\n";
                }
                ++n;
            }
        }
        return string;
    }
}

