/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.CommandResultBuffer;
import JIMSCore.Coprocessor0;
import JIMSCore.Coprocessor1;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.RegisterFile;
import java.util.StringTokenizer;

public class Command {
    protected StringTokenizer stSource;
    protected static final String RESPONSE = "*";
    protected static final String DONE = "DONE";

    public Command() {
    }

    public Command(StringTokenizer stringTokenizer) {
        this.stSource = stringTokenizer;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        throw new InvalidCommandUseException("Command not yet implemented.");
    }

    public String nextToken() {
        String string = "";
        try {
            string = this.stSource.nextToken();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    protected static int iGetNumber(String string) throws NumberFormatException {
        int n = 0;
        string = string.toUpperCase();
        try {
            long l = 0L;
            l = string.startsWith("0X") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            if (l > 0xFFFFFFFFL || l < Integer.MIN_VALUE) {
                throw new NumberFormatException("Must specify at most a 32-bit number.");
            }
            n = (int)l;
        }
        catch (Exception exception) {
            throw new NumberFormatException("Invalid number specified.");
        }
        return n;
    }

    protected static int iGetRegisterIndex(String string, int n) throws NumberFormatException {
        int n2 = -1;
        try {
            int n3 = -1;
            switch (n) {
                case 0: {
                    n2 = RegisterFile.iRegLiteralToID(string);
                    n3 = 35;
                    break;
                }
                case 1: {
                    n2 = Coprocessor0.iRegLiteralToID(string);
                    n3 = 32;
                    break;
                }
                case 2: {
                    n2 = Coprocessor1.iRegLiteralToID(string);
                    n3 = 34;
                    break;
                }
            }
            if (n2 == -1) {
                if (string.charAt(0) == '$') {
                    string = string.substring(1);
                }
                n2 = Command.iGetNumber(string);
            }
            if (n2 < 0 || n2 >= n3) {
                throw new NumberFormatException("Invalid register number.");
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException("Invalid register specified.");
        }
        return n2;
    }

    protected static int[] iaGetRegisterRangeOrValue(String string, int n) {
        int[] nArray = new int[2];
        try {
            int n2 = string.indexOf("-");
            if (n2 == -1) {
                nArray[0] = Command.iGetRegisterIndex(string, n);
                nArray[1] = nArray[0];
            } else {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                nArray[0] = Command.iGetRegisterIndex(string2, n);
                nArray[1] = Command.iGetRegisterIndex(string3, n);
                if (nArray[1] < nArray[0]) {
                    int n3 = nArray[1];
                    nArray[1] = nArray[0];
                    nArray[0] = n3;
                }
            }
        }
        catch (Exception exception) {
            nArray = null;
        }
        return nArray;
    }

    protected static int[] iaGetMemoryRangeOrValue(String string) {
        int[] nArray = new int[2];
        try {
            int n = string.indexOf("-");
            if (n == -1) {
                nArray[0] = Command.iGetNumber(string);
                nArray[1] = nArray[0];
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                nArray[0] = Command.iGetNumber(string2);
                nArray[1] = Command.iGetNumber(string3);
            }
        }
        catch (Exception exception) {
            nArray = null;
        }
        return nArray;
    }
}

