/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.DataEntry;
import JIMSCore.DataSection;
import JIMSCore.DirectiveProcessor;
import JIMSCore.InstructionEncoder;
import JIMSCore.LabelEntry;
import JIMSCore.ModifiedSource;
import JIMSCore.TextEntry;
import JIMSCore.TextSection;
import JIMSCore.Utility;
import java.util.Enumeration;
import java.util.Vector;

public class Assembler {
    public static final char NEWLINE = '\n';
    public static final int MODE_TEXT = 1;
    public static final int MODE_DATA = 2;
    public static final int MODE_KTEXT = 3;
    public static final int MODE_KDATA = 4;
    public static final int MODE_NONE = 0;
    public static final int TEXT_SECTION = 0;
    public static final int DATA_SECTION = 1;
    public int iCurrentMode;
    public int iCurrentTextIndex;
    public int iCurrentDataIndex;
    public Vector vLabelVector;
    public Vector vTextSection;
    public TextSection currentTextSection;
    public int iCurrentTextSectionIndex;
    public Vector vDataSection;
    public DataSection currentDataSection;
    public int iCurrentDataSectionIndex;
    private InstructionEncoder instructionEncoder;
    private DirectiveProcessor directiveProcessor;
    private static int iInvalidUseOfAT;
    private int iPhaseTwoErrors;

    public Assembler(String string) {
        ModifiedSource.setOutputFile(string);
        this.reset();
    }

    public Assembler() {
        this(null);
    }

    public void reset() {
        this.iCurrentMode = 0;
        this.vLabelVector = new Vector();
        this.vTextSection = null;
        this.iCurrentTextSectionIndex = -1;
        this.vDataSection = null;
        this.iCurrentDataSectionIndex = -1;
        this.instructionEncoder = new InstructionEncoder(this);
        this.directiveProcessor = new DirectiveProcessor(this);
        iInvalidUseOfAT = -1;
        ModifiedSource.start();
    }

    public int iGetLastInvalidUseOfAT() {
        return iInvalidUseOfAT;
    }

    public int iProcessLine(String string, int n) throws Exception {
        int n2;
        int n3;
        iInvalidUseOfAT = -1;
        String string2 = string.substring(0);
        if (string2.trim().equals("")) {
            return 0;
        }
        boolean bl = true;
        int n4 = 0;
        while (n4 < string2.length()) {
            n3 = string2.charAt(n4);
            if (n3 == 34) {
                bl = !bl;
            } else if (n3 == 35 && bl) {
                string2 = string2.substring(0, n4);
                break;
            }
            ++n4;
        }
        n3 = -1;
        String string3 = "";
        int n5 = 0;
        while (n5 < string2.length()) {
            n2 = string2.charAt(n5);
            if (n2 == 58) {
                n3 = n5;
                break;
            }
            if (n2 == 34) break;
            ++n5;
        }
        if (n3 == 0) {
            throw new Exception("Line " + n + "\n" + "Line cannot start with colon." + "\n\n" + string2);
        }
        if (n3 > 0) {
            string3 = string2.substring(0, n3).trim();
            if (this.iGetLabelIndex(string3) != -1) {
                throw new Exception("Line " + n + "\n" + "Label already defined: " + string3 + "\n\n" + string2);
            }
            string2 = string2.substring(n3 + 1).trim();
            LabelEntry labelEntry = null;
            switch (this.iCurrentMode) {
                case 1: 
                case 3: {
                    labelEntry = new LabelEntry(string3, 0, this.iCurrentTextSectionIndex, this.iCurrentTextIndex);
                    break;
                }
                case 2: 
                case 4: {
                    labelEntry = new LabelEntry(string3, 1, this.iCurrentDataSectionIndex, this.iCurrentDataIndex);
                    break;
                }
                default: {
                    throw new Exception("Line " + n + "\n" + "Invalid mode while adding label: " + string3 + "\n\n" + string2);
                }
            }
            this.vLabelVector.add(labelEntry);
        }
        if ((string2 = string2.trim()).equals("")) {
            ModifiedSource.append(string);
        } else if (string2.charAt(0) == '.') {
            n2 = this.iProcessDirective(string, string2, n);
            if (n2 != 0) {
                throw new Exception("Line " + n + "\n" + "Generic directive error." + "\n\n" + string2);
            }
        } else {
            n2 = 0;
            n2 = this.iProcessInstruction(string, string2, n);
            if (n2 != 0) {
                throw new Exception("Line " + n + "\n" + "Generic text error." + "\n\n" + string2);
            }
        }
        return 0;
    }

    private int iProcessInstruction(String string, String string2, int n) throws Exception {
        switch (this.iCurrentMode) {
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new Exception("Line " + n + "\n" + "Mode is not text." + "\n\n" + string2);
            }
        }
        this.instructionEncoder.processInstruction(string, string2, n);
        return 0;
    }

    private int iProcessDirective(String string, String string2, int n) {
        try {
            int n2 = this.directiveProcessor.iProcessDirective(string2, n);
            if (n2 != 0) {
                return -1;
            }
            ModifiedSource.append(string);
        }
        catch (Exception exception) {
            return -2;
        }
        return 0;
    }

    public StringBuffer sbGetMachineCode(String string) throws Exception {
        Object object;
        Enumeration enumeration;
        this.iPhaseTwoErrors = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equals("")) {
            stringBuffer.append("S " + string + "\n");
        }
        if (this.vTextSection != null) {
            enumeration = this.vTextSection.elements();
            while (enumeration.hasMoreElements()) {
                object = (TextSection)enumeration.nextElement();
                stringBuffer.append((Object)this.sbProcessTextSection((TextSection)object));
            }
        }
        if (this.vDataSection != null) {
            enumeration = this.vDataSection.elements();
            while (enumeration.hasMoreElements()) {
                object = (DataSection)enumeration.nextElement();
                stringBuffer.append((Object)this.sbProcessDataSection((DataSection)object));
            }
        }
        return stringBuffer;
    }

    public int iGetNumPhaseTwoErrors() {
        return this.iPhaseTwoErrors;
    }

    private StringBuffer sbProcessTextSection(TextSection textSection) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = textSection.vTextVector.elements();
        int n = textSection.iAddress;
        while (enumeration.hasMoreElements()) {
            TextEntry textEntry = (TextEntry)enumeration.nextElement();
            String string = this.sFinalizeInstruction(textEntry.sGetInstruction(), textEntry.iSourceLine, n);
            stringBuffer.append("T " + Utility.sAsHexPadded(n, 8) + " " + this.sCompressBitSequence(string) + " L" + textEntry.iSourceLine);
            stringBuffer.append('\n');
            n += 4;
        }
        return stringBuffer;
    }

    private StringBuffer sbProcessDataSection(DataSection dataSection) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = dataSection.vDataVector.elements();
        while (enumeration.hasMoreElements()) {
            DataEntry dataEntry = (DataEntry)enumeration.nextElement();
            String string = this.sFinalizeData(dataEntry.sData);
            stringBuffer.append("D " + Utility.sAsHexPadded(dataEntry.iAddress, 8) + " " + string);
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    private String sFinalizeData(String string) {
        int n;
        while ((n = string.indexOf("addr(")) >= 0) {
            int n2 = n + 5;
            while (string.charAt(n2) != ')') {
                ++n2;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 5, n2);
            if (this.bLabelDefined(string3)) {
                int n3 = this.iGetLabelAddress(string3);
                string3 = Utility.sAsBinaryPadded(n3, 32);
            }
            String string4 = string.substring(n2 + 1);
            string = string2 + string3 + string4;
        }
        return this.sProcessedDataString(string);
    }

    private String sFinalizeInstruction(String string, int n, int n2) throws Exception {
        String string2;
        String string3;
        int n3;
        String string4;
        String string5;
        int n4;
        int n5 = string.indexOf("shamt(");
        if (n5 >= 0) {
            n4 = n5 + 6;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 6, n4);
            n3 = (int)Utility.IntegerLiteralToLong(string4);
            string4 = Utility.sAsBinaryPadded(n3, 5);
            string3 = string.substring(n4 + 1);
            string = string5 + string4 + string3;
        }
        if ((n5 = string.indexOf("hi16(")) >= 0) {
            n4 = n5 + 5;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 5, n4);
            n3 = 0;
            if (string4.startsWith("+4|")) {
                string4 = string4.substring(3);
                n3 = 4;
            }
            int n6 = 0;
            if (this.bLabelDefined(string4)) {
                n6 = this.iGetLabelAddress(string4);
            } else {
                try {
                    n6 = (int)Utility.IntegerLiteralToLong(string4);
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            n6 += n3;
            n6 = (n6 & 0xFFFF0000) >>> 16;
            string2 = string.substring(n4 + 1);
            string = string5 + n6 + string2;
        }
        if ((n5 = string.indexOf("lo16(")) >= 0) {
            n4 = n5 + 5;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 5, n4);
            n3 = 0;
            if (string4.startsWith("+4|")) {
                string4 = string4.substring(3);
                n3 = 4;
            }
            int n7 = 0;
            if (this.bLabelDefined(string4)) {
                n7 = this.iGetLabelAddress(string4);
            } else {
                try {
                    n7 = (int)Utility.IntegerLiteralToLong(string4);
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            n7 += n3;
            string2 = string.substring(n4 + 1);
            string = string5 + (n7 &= 0xFFFF) + string2;
        }
        if ((n5 = string.indexOf("target(")) >= 0) {
            n4 = n5 + 6;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 7, n4);
            n3 = 0;
            if (this.bLabelDefined(string4)) {
                n3 = this.iGetLabelAddress(string4);
            } else {
                try {
                    n3 = (int)Utility.IntegerLiteralToLong(string4);
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            n3 = (n3 & 0x3FFFFFF) >> 2;
            string4 = Utility.sAsBinaryPadded(n3, 26);
            string3 = string.substring(n4 + 1);
            string = string5 + string4 + string3;
            return string;
        }
        n5 = string.indexOf("imm(");
        if (n5 >= 0) {
            n4 = n5 + 4;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 4, n4);
            n3 = 0;
            if (string4.startsWith("+4|")) {
                string4 = string4.substring(3);
                n3 = 4;
            }
            int n8 = 0;
            if (this.bLabelDefined(string4)) {
                n8 = this.iGetLabelAddress(string4);
            } else {
                try {
                    n8 = (int)Utility.IntegerLiteralToLong(string4);
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            string4 = Utility.sAsBinaryPadded(n8 + n3, 16);
            string2 = string.substring(n4 + 1);
            string = string5 + string4 + string2;
            return string;
        }
        n5 = string.indexOf("branch(");
        if (n5 >= 0) {
            n4 = n5 + 7;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 7, n4);
            n3 = 0;
            if (this.bLabelDefined(string4)) {
                n3 = this.iGetLabelAddress(string4);
                n3 = n3 - n2 >> 2;
            } else {
                try {
                    n3 = (int)Utility.IntegerLiteralToLong(string4) >> 2;
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            string4 = Utility.sAsBinaryPadded(n3, 16);
            string3 = string.substring(n4 + 1);
            string = string5 + string4 + string3;
            return string;
        }
        n5 = string.indexOf("offset(");
        if (n5 >= 0) {
            n4 = n5 + 6;
            while (string.charAt(n4) != ')') {
                ++n4;
            }
            string5 = string.substring(0, n5);
            string4 = string.substring(n5 + 7, n4);
            n3 = 0;
            if (this.bLabelDefined(string4)) {
                n3 = this.iGetLabelAddress(string4);
            } else {
                try {
                    n3 = (int)Utility.IntegerLiteralToLong(string4);
                }
                catch (Exception exception) {
                    ++this.iPhaseTwoErrors;
                    throw new Exception("Line " + n + "\n" + "Undefined label or invalid value: " + string4);
                }
            }
            string4 = Utility.sAsBinaryPadded(n3, 16);
            string3 = string.substring(n4 + 1);
            string = string5 + string4 + string3;
            return string;
        }
        return string;
    }

    public String toString() {
        Object object;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.vLabelVector != null) {
            stringBuffer.append("\nLABEL:\n");
            enumeration = this.vLabelVector.elements();
            while (enumeration.hasMoreElements()) {
                object = (LabelEntry)enumeration.nextElement();
                stringBuffer.append(object + "\n");
            }
        }
        if (this.vTextSection != null) {
            stringBuffer.append("\nTEXT:\n");
            enumeration = this.vTextSection.elements();
            while (enumeration.hasMoreElements()) {
                object = (TextSection)enumeration.nextElement();
                stringBuffer.append(object + "\n");
            }
        }
        if (this.vDataSection != null) {
            stringBuffer.append("\nDATA:\n");
            enumeration = this.vDataSection.elements();
            while (enumeration.hasMoreElements()) {
                object = (DataSection)enumeration.nextElement();
                stringBuffer.append(object + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean bLabelDefined(String string) {
        boolean bl = false;
        Enumeration enumeration = this.vLabelVector.elements();
        while (enumeration.hasMoreElements()) {
            LabelEntry labelEntry = (LabelEntry)enumeration.nextElement();
            if (!labelEntry.sName.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int iGetLabelAddress(String string) {
        int n = 0;
        Enumeration enumeration = this.vLabelVector.elements();
        while (enumeration.hasMoreElements()) {
            LabelEntry labelEntry = (LabelEntry)enumeration.nextElement();
            if (!labelEntry.sName.equals(string)) continue;
            if (labelEntry.iSection == 0) {
                TextSection textSection = (TextSection)this.vTextSection.elementAt(labelEntry.iSectionIndex);
                n = textSection.iAddress + labelEntry.iIndex * 4;
                break;
            }
            DataSection dataSection = (DataSection)this.vDataSection.elementAt(labelEntry.iSectionIndex);
            DataEntry dataEntry = (DataEntry)dataSection.vDataVector.elementAt(labelEntry.iIndex);
            n = dataEntry.iAddress;
            break;
        }
        return n;
    }

    private int iGetLabelIndex(String string) {
        Enumeration enumeration = this.vLabelVector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            LabelEntry labelEntry = (LabelEntry)enumeration.nextElement();
            if (!labelEntry.sName.equals(string)) continue;
            return n;
        }
        return -1;
    }

    public void addToDataVector(DataEntry dataEntry) {
        this.currentDataSection.vDataVector.add(dataEntry);
        ++this.iCurrentDataIndex;
    }

    public void addToTextVector(TextEntry textEntry) {
        if (DirectiveProcessor.bWarnAboutAT && (Assembler.isAT(textEntry.rs) || Assembler.isAT(textEntry.rt) || Assembler.isAT(textEntry.rd))) {
            Assembler.warnAboutUseOfAT(textEntry.iSourceLine);
        }
        this.currentTextSection.vTextVector.add(textEntry);
        ++this.iCurrentTextIndex;
    }

    private String sProcessedDataString(String string) {
        String string2 = string.trim();
        string2 = Utility.sRemoveChar(string2, ' ');
        String string3 = "";
        do {
            String string4 = string2.substring(0, 2);
            string3 = string3 + string4 + " ";
        } while (!(string2 = string2.substring(2)).equals(""));
        return string3.trim();
    }

    private String sCompressBitSequence(String string) {
        String string2 = Utility.sRemoveChar(string, ' ');
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            int n3 = Integer.parseInt(string2.substring(n, n + 8), 2);
            stringBuffer.append(Utility.sAsHexPadded(n3, 2) + " ");
            n += 8;
        }
        return stringBuffer.toString();
    }

    public static void warnAboutUseOfAT(int n) {
        iInvalidUseOfAT = n;
    }

    public static boolean isAT(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toUpperCase()).equals("$AT") || string.equals("AT") || string.equals("$1") || string.equals("1");
    }

    public static String[] saGetParams(String string) {
        Vector vector = Assembler.vGetParams(string);
        if (vector == null) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    private static Vector vGetParams(String string) {
        Vector<String> vector = new Vector<String>();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == ',' || c == ' ' || c == '\t') {
                if (bl) {
                    if (c == ',') {
                        System.err.println("ERROR: Invalid use of comma (,).");
                        return null;
                    }
                } else {
                    if (stringBuffer.length() > 0) {
                        vector.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                    }
                    bl = true;
                }
            } else if (c == '\"') {
                if (stringBuffer.length() > 0) {
                    System.err.println("ERROR: Invalid content between string declarations.");
                    return null;
                }
                stringBuffer.append(c);
                do {
                    if (++n >= cArray.length) {
                        System.err.println("ERROR: String literal parameter not properly terminated.");
                        return null;
                    }
                    c = cArray[n];
                    stringBuffer.append(c);
                } while (c != '\"');
                vector.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            } else {
                bl = false;
                stringBuffer.append(c);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            vector.add(stringBuffer.toString());
        }
        return vector;
    }
}

