function a = vec_unrank ( n, base, rank )

%% VEC_UNRANK computes the product space element of a given rank.
%
%  Discussion:
%
%    The rank applies only to the elements as produced by the routine
%    VEC_NEXT2.
%
%  Examples:
%
%    N = 2, BASE = ( 2, 3 ), RANK = 4.
%
%    A = ( 1, 2 ).
%
%  Modified:
%
%    18 June 2004
%
%  Reference:
%
%    Dennis Stanton and Dennis White,
%    Constructive Combinatorics,
%    Springer Verlag, New York, 1986.
%
%  Parameters:
%
%    Input, integer N, the number of components.
%
%    Input, integer BASE(N), contains the number of degrees of
%    freedom of each component.  The output values of A will
%    satisfy 0 <= A(I) < BASE(I).
%
%    Input, integer RANK, the desired rank, or order, of the element in
%    the list of all elements.  The rank count begins at 1 and extends
%    to MAXRANK = Product ( 1 <= I <= N ) BASE(I).
%
%    Output, integer A(N), the product space element of the given rank.
%
  s = rank - 1;

  for i = n : -1 : 1

    a(i) = mod ( s, base(i) );
    s = floor ( s / base(i) );

    if ( mod ( s, 2 ) == 1 )
      a(i) = base(i) - a(i) - 1;
    end

  end
