function rank = vec_rank ( n, base, a )

%% VEC_RANK computes the rank of a product space element.
%
%  Discussion:
%
%    The rank applies only to the elements as produced by the routine
%    VEC_NEXT2.
%
%  Examples:
%
%    N = 2, BASE = (/ 2, 3 /), A = ( 1, 2 ),
%
%    RANK = 4.
%
%  Modified:
%
%    18 June 2004
%
%  Reference:
%
%    Dennis Stanton and Dennis White,
%    Constructive Combinatorics,
%    Springer Verlag, New York, 1986.
%
%  Parameters:
%
%    Input, integer N, the number of components.
%
%    Input, integer BASE(N), contains the number of degrees of
%    freedom of each component.  The output values of A will
%    satisfy 0 <= A(I) < BASE(I).
%
%    Input, integer A(N), the product space element, with the
%    property that 0 <= A(I) < BASE(I) for each entry I.
%
%    Output, integer RANK, the rank, or order, of the element in
%    the list of all elements.  The rank count begins at 1.
%
  rank = 0;

  for i = 1 : n

    if ( mod ( rank, 2 ) == 1 )
      c = base(i) - a(i) - 1;
    else
      c = a(i);
    end

    rank = base(i) * rank + c;

  end

  rank = rank + 1;
