%% TEST155 tests VEC_NEXT_GRAY, VEC_RANK, VEC_UNRANK.
%
%  Modified:
%
%    11 October 2006
%
%  Author:
%
%    John Burkardt
%
  clear

  n = 4;
  base = [ 2, 2, 1, 4 ];
  number = prod ( base );

  fprintf ( 1, '\n' );
  fprintf ( 1, 'TEST155\n' );
  fprintf ( 1, '  VEC_NEXT_GRAY generates product space elements.\n' );
  fprintf ( 1, '  VEC_RANK ranks them.\n' );
  fprintf ( 1, '  VEC_UNRANK unranks them.\n' );
  fprintf ( 1, '\n' );
  fprintf ( 1, '  The number of components is %d\n', n );
  fprintf ( 1, '  The number of elements is %d\n', number );
  fprintf ( 1, '  Each component has its own number of degrees of\n' );
  fprintf ( 1, '  freedom, which, for this example, are:\n' );
  fprintf ( 1, '\n' );
  fprintf ( 1, '  Rank Change     ' );
  for i = 1 : n
    fprintf ( 1, '  %4d', base(i) );
  end
  fprintf ( 1, '\n' );
  fprintf ( 1, '\n' );
  rank = 0;
  
  a = [];
  done = 1;
 
  while ( 1 )
 
    rank = rank + 1;
 
    [ a, done, change ] = vec_next_gray ( n, base, a, done );
 
    if ( done )
      break
    end

    fprintf ( 1, '  %4d  %4d      ', rank, change );
    for i = 1 : n
      fprintf ( 1, '  %4d', a(i) );
    end
    fprintf ( 1, '\n' );

  end
 
  a(1:n) = floor ( base(1:n) / 2 );

  rank = vec_rank ( n, base, a );

  fprintf ( 1, '\n' );
  fprintf ( 1, '  VEC_RANK reports the element \n' );
  fprintf ( 1, '\n' );
  for i = 1 : n
    fprintf ( 1, '  %4d', a(i) );
  end
  fprintf ( 1, '\n' );
  fprintf ( 1, '\n' );
  fprintf ( 1, '  has rank %d\n', rank );

  rank = 7;
  a = vec_unrank ( n, base, rank );

  fprintf ( 1, '\n' );
  fprintf ( 1, '  VEC_UNRANK reports the element of rank %d\n', rank );
  fprintf ( 1, '  is:\n' );
  fprintf ( 1, '\n' );
  for i = 1 : n
    fprintf ( 1, '  %4d', a(i) );
  end
  fprintf ( 1, '\n' );
  fprintf ( 1, '\n' );
