%% TEST069 tests JFRAC_TO_RFRAC, RFRAC_TO_JFRAC.
%
  clear

  m = 3;
  p(1:3) = [ 1.0, 1.0, 2.0 ];
  q(1:4) = [ 1.0, 3.0, 1.0, 1.0 ];
  fprintf ( 1, '\n' );
  fprintf ( 1, 'TEST069\n' );
  fprintf ( 1, '  RFRAC_TO_JFRAC converts a rational polynomial\n' );
  fprintf ( 1, '    fraction to a J fraction.\n' );
  fprintf ( 1, '  JFRAC_TO_RFRAC converts a J fraction\n' );
  fprintf ( 1, '    to a rational polynomial fraction.\n' );
  fprintf ( 1, '\n' );
  fprintf ( 1, '  The original rational polynomial coefficients:\n' );
  fprintf ( 1, '\n' );
  for i = 1 : m
    fprintf ( 1, '  %12f', p(i) );
  end
  fprintf ( 1, '\n' );
  for i = 1 : m + 1
    fprintf ( 1, '  %12f', q(i) );
  end
  fprintf ( 1, '\n' );
 
  [ r, s ] = rfrac_to_jfrac ( m, p, q );
 
  fprintf ( 1, '\n' );
  fprintf ( 1, '  The J fraction coefficients:\n' );
  fprintf ( 1, '\n' );
  for i = 1 : m
    fprintf ( 1, '  %8f', r(i) );
  end
  fprintf ( 1, '\n' );
  for i = 1 : m
    fprintf ( 1, '  %8f', s(i) );
  end
  fprintf ( 1, '\n' );
 
  [ p, q ] = jfrac_to_rfrac ( m, r, s );

  fprintf ( 1, '\n' );
  fprintf ( 1, '  The recovered rational polynomial:\n' );
  fprintf ( 1, '\n' );
  for i = 1 : m
    fprintf ( 1, '  %8f', p(i) );
  end
  fprintf ( 1, '\n' );
  for i = 1 : m+1
    fprintf ( 1, '  %8f', q(i) );
  end
  fprintf ( 1, '\n' );
