#!/bin/csh
#
#  Purpose:
#
#    Create a GZIP'ed TAR file of the m_src/subset files.
#
#  Modified:
#
#    02 January 2006
#
#  Author:
#
#    John Burkardt
#
#  Move to the directory just above the "subset" directory.
#
cd $HOME/public_html/m_src
#
#  Delete any TAR or GZ file in the directory.
#
echo "Remove TAR and GZ files."
rm subset/*.tar
rm subset/*.gz
#
#  Create a TAR file of the "subset" directory.
#
echo "Create TAR file."
tar cvf subset_m_src.tar subset/*
#
#  Compress the file.
#
echo "Compress the TAR file."
gzip subset_m_src.tar
#
#  Move the compressed file into the "subset" directory.
#
echo "Move the compressed file into the directory."
mv subset_m_src.tar.gz subset
#
#  Say goodnight.
#
echo "The subset_m_src gzip file has been created."
