function s_new = s_blanks_delete ( s )

%% S_BLANKS_DELETE replaces consecutive blanks by one blank.
%
%  Discussion:
%
%    The remaining characters are left justified and right padded with blanks.
%    TAB characters are converted to spaces.
%
%  Modified:
%
%    20 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, character S(*), the string to be transformed.
%
%    Output, character S_NEW(*), the transformed string.
%
  s_length = length ( s );
  s_new = [];

  TAB = 9;

  j = 0;
  newchr = ' ';

  for i = 1 : s_length

    oldchr = newchr;
    newchr = s(i);

    if ( newchr == TAB )
      newchr = ' ';
    end

    if ( oldchr ~= ' ' | newchr ~= ' ' )
      j = j + 1;
      s_new(j) = newchr
    end

  end
