function [ a_new, b_new ] = rat_normalize ( a, b )

%% RAT_NORMALIZE normalizes a rational number.
%
%  Discussion:
%
%    If A = B = 0, return.
%
%    If A = 0 (and B nonzero) set B => 1 and return.
%
%    If A nonzero, and B = 0, then A => 1 and return.
%
%    If A = B, then set A => 1, B => 1 and return.
%
%    If B < 0, then A => -A, B => -B.
%
%    If 1 < C = GCD(|A|,|B|), A => A/C, B => B/C.
%
%  Modified:
%
%    27 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer A, B, the rational number.
%
%    Output, integer A_NEW, B_NEW, the normalized rational number.
%
  a_new = a;
  b_new = b;
%
%  Cases where one or both is 0.
%
  if ( a_new == 0 & b_new == 0 )
    return
  elseif ( a_new == 0 & b_new ~= 0 )
    b_new = 1;
    return
  elseif ( a_new ~= 0 & b_new == 0 )
    a_new = 1;
    return
  end

  if ( a_new == b_new )
    a_new = 1;
    b_new = 1;
    return
  end
    
  if ( b_new < 0 )
    a_new = -a_new;
    b_new = -b_new;
  end

  c = i4_gcd ( abs ( a_new ), abs ( b_new ) );

  if ( 1 < c )
    a_new = a_new / c;
    b_new = b_new / c;
  end

