function random_initialize ( seed )

%% RANDOM_INITIALIZE initializes the MATLAB random number seed.
%
%  Discussion:
%
%    If you don't initialize the random number generator, its behavior
%    is not specified.  By specifying a particular seed value before generating
%    a series of random numbers, it is possible to regenerate that series
%    at any time by reinitializing the random number generator with that seed.
%
%  Modified:
%
%    12 August 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer SEED, the seed to use for the random number generator.
%
  debug = 0;

  if ( seed ~= 0 )

    if ( debug )
      fprintf ( 1, '\n' );
      fprintf ( 1, 'RANDOM_INITIALIZE:\n' );
      fprintf ( 1, '  Initialize RANDOM_NUMBER, user SEED = %d\n', seed );
    end

  else

    seed = get_seed ( seed );

    if ( debug )
      fprintf ( 1, '\n' );
      fprintf ( 1, 'RANDOM_INITIALIZE:\n' );
      fprintf ( 1, '  Initialize RANDOM_NUMBER, arbitrary SEED = %d\n', seed );
    end

  end

  rand ( 'state', seed );
