function [ a, b, c, i_new, j_new ] = pythag_triple_next ( i, j )

%% PYTHAG_TRIPLE_NEXT computes the next Pythagorean triple.
%
%  Example:
%
%     I       J       A       B       C    A^2+B^2 = C^2
%
%     2       1       3       4       5      25
%     3       2       5      12      13     169
%     4       1      15       8      17     289
%     4       3       7      24      25     625
%     5       2      21      20      29     841
%     5       4       9      40      41    1681
%     6       1      35      12      37    1369
%     6       3      27      36      45    2025
%     6       5      11      60      61    3721
%     7       2      45      28      53    2809
%
%  Modified:
%
%    21 July 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer I, J, the generators.
%    On first call, set I = J = 0.  On repeated calls, set I and J
%    to the output values of I_NEW and J_NEW from the previous call.
%
%    Output, integer A, B, C, the next Pythagorean triple.
%    A, B, and C are positive integers which have no common factors,
%    and A**2 + B**2 = C**2.
%
%    Output, integer I_NEW, J_NEW, the updated values of the generators,
%    which should be used as the input values of I and J if the routine
%    is to be called again.
%
  i_new = i;
  j_new = j;
%
%  I starts at 2, and when it increases, increases by 1 and resets J;
%
%  When I is reset, J starts out at 2 if I is odd, or 1 if I is even;
%  Then I is held fixed and J increases by 2, as long as it remains less than I.
%
  if ( i_new == 0 & j_new == 0 )
    i_new = 2;
    j_new = 1;
  elseif ( j_new + 2 < i_new )
    j_new = j_new + 2;
  else
    i_new = i_new + 1;
    j_new = mod ( i_new, 2 ) + 1;
  end

  a = i_new^2 - j_new^2;
  b = 2 * i_new * j_new;
  c = i_new^2 + j_new^2;
