function p = perrin ( n )

%% PERRIN returns the first N values of the Perrin sequence.
%
%  Discussion:
%
%    The Perrin sequence has the initial values:
%
%      P(0) = 3
%      P(1) = 0
%      P(2) = 2
%
%    and subsequent entries are generated by the recurrence
%
%      P(I+1) = P(I-1) + P(I-2)
%
%    Note that if N is a prime, then N must evenly divide P(N).
%
%  Example:
%
%    0   3
%    1   0
%    2   2
%    3   3
%    4   2
%    5   5
%    6   5
%    7   7
%    8  10
%    9  12
%   10  17
%
%  Modified:
%
%    15 August 2004
%
%  Author:
%
%    John Burkardt
%
%  Reference:
%
%    Ian Stewart,
%    "A Neglected Number",
%    Scientific American, Volume 274, pages 102-102, June 1996.
%
%    Ian Stewart,
%    Math Hysteria,
%    Oxford, 2004.
%
%    Eric Weisstein,
%    CRC Concise Encyclopedia of Mathematics,
%    CRC Press, 1999.
%
%  Parameters:
%
%    Input, integer N, the number of terms.
%
%    Output, integer P(N), the terms 0 through N-1 of the sequence.
%
  if ( n < 1 )
    p = [];
    return
  end

  p(1) = 3;

  if ( n < 2 )
    return
  end

  p(2) = 0;

  if ( n < 3 )
    return
  end
 
  p(3) = 2;

  for i = 4 : n
    p(i) = p(i-2) + p(i-3);
  end
