function p = padovan ( n )

%% PADOVAN returns the first N values of the Padovan sequence.
%
%  Discussion:
%
%    The Padovan sequence has the initial values:
%
%      P(0) = 1
%      P(1) = 1
%      P(2) = 1
%
%    and subsequent entries are generated by the recurrence
%
%      P(I+1) = P(I-1) + P(I-2)
%
%  Example:
%
%    0   1
%    1   1
%    2   1
%    3   2
%    4   2
%    5   3
%    6   4
%    7   5
%    8   7
%    9   9
%   10  12
%
%  Modified:
%
%    15 August 2004
%
%  Author:
%
%    John Burkardt
%
%  Reference:
%
%    Ian Stewart,
%    "A Neglected Number",
%    Scientific American, Volume 274, pages 102-102, June 1996.
%
%    Ian Stewart,
%    Math Hysteria,
%    Oxford, 2004.
%
%  Parameters:
%
%    Input, integer N, the number of terms.
%
%    Output, integer P(N), terms 0 though N-1 of the Perrin sequence.
%
  if ( n < 1 )
    p = [];
    return
  end

  p(1) = 1;

  if ( n < 2 )
    return
  end

  p(2) = 1;

  if ( n < 3 )
    return
  end
 
  p(3) = 1;

  for i = 4 : n
    p(i) = p(i-2) + p(i-3);
  end
