function [ i_new, j_new, k_new, more_new ] = index_box_next_3d ( n1, n2, n3, ...
  i, j, k, more )

%% INDEX_BOX_NEXT_3D produces index vectors on the surface of a box in 3D.
%
%  Discussion:
%
%    The index vectors are exactly those which are between (1,1,1) and
%    (N1,N2,N3) with the property that at least one of I, J, and K
%    is an "extreme" value.
%
%  Modified:
%
%    28 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N1, N2, N3, the "dimensions" of the box, that is, the
%    maximum values allowed for I, J and K.  The minimum values are
%    assumed to be 1.
%
%    Input, integer I, J, K, the previous index set.  However, on 
%    first call, with MORE = FALSE, the input values of I, J and K are not needed.
%
%    Input, logical MORE, is set to FALSE on the first call, and should be
%    TRUE thereafter.
%
%    Output, integer I_NEW, J_NEW, K_NEW, the next index set.  
%
%    Output, logical MORE_NEW, is TRUE if there are more index sets available.
%
  more_new = more;

  if ( ~more_new )
    more_new = 1;
    i_new = 1;
    j_new = 1;
    k_new = 1;
    return
  end

  i_new = i;
  j_new = j;
  k_new = k;

  if ( i_new == n1 & j_new == n2 & k_new == n3 )
    more_new = 0;
    return
  end
%
%  Increment K.
%
  k_new = k_new + 1;
%
%  Check K.
%
  if ( n3 < k_new )
    k_new = 1;
    j_new = j_new + 1;
  elseif ( k_new < n3 & ( i_new == 1 | i_new == n1 | j_new == 1 | j_new == n2 ) )
    return
  else
    k_new = n3;
    return
  end
%
%  Check J.
%
  if ( n2 < j_new )
    j_new = 1;
    i_new = i_new + 1;
  elseif ( j_new < n2 & ( i_new == 1 | i_new == n1 | k_new == 1 | k_new == n3 ) )
    return
  else
    j_new = n2;
    return
  end
