function [ i_new, j_new, more_new ] = index_box_next_2d ( n1, n2, i, j, more )

%% INDEX_BOX_NEXT_2D produces index vectors on the surface of a box in 2D.
%
%  Discussion:
%
%    The index vectors are exactly those which are between (1,1) and
%    (N1,N2) with the property that at least one of I and J
%    is an "extreme" value.
%
%  Modified:
%
%    28 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N1, N2, the "dimensions" of the box, that is, the
%    maximum values allowed for I and J.  The minimum values are
%    assumed to be 1.
%
%    Input, integer I, J, the previous index set.  The values of I and J
%    are not needed on the first call, with MORE set to FALSE.
%
%    Input, logical MORE, is FALSE on the first call, and TRUE therafter.
%
%    Output, integer I_NEW, J_NEW, the next index set.  
%
%    Output, logical MORE_NEW, is TRUE if the routine can be called again
%    for more index sets.
%
  more_new = more;

  if ( ~more_new )
    more_new = 1;
    i_new = 1;
    j_new = 1;
    return
  end

  i_new = i;
  j_new = j;

  if ( i_new == n1 & j_new == n2 )
    more_new = 0;
    return
  end
%
%  Increment J.
%
  j_new = j_new + 1;
%
%  Check J.
%
  if ( n2 < j_new )
    j_new = 1;
    i_new = i_new + 1;
  elseif ( j_new < n2 & ( i_new == 1 | i_new == n1 ) )

  else
    j_new = n2;
  end

