function [ i_new, j_new, k_new, more_new ] = index_box2_next_3d ( n1, n2, n3, ...
  ic, jc, kc, i, j, k, more )

%% INDEX_BOX2_NEXT_3D produces index vectors on the surface of a box in 3D.
%
%  Discussion:
%
%    The box has a central cell of (IC,JC,KC), with a half widths of
%    (N1,N2,N3).  The index vectors are exactly those between
%    (IC-N1,JC-N2,KC-N3) and (IC+N1,JC+N2,KC+N3) with the property that 
%    at least one of I, J, and K is an "extreme" value.
%
%  Modified:
%
%    31 July 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N1, N2, N3, the "half widths" of the box, that is, the
%    maximum distances from the central cell allowed for I, J and K.
%
%    Input, integer IC, JC, KC, the central cell of the box.
%
%    Input, integer I, J, K.  On input with MORE = TRUE, the previous index set;
%    If MORE is FALSE, the input values of I, J and K are not needed.
%
%    Input, logical MORE, is FALSE on an initialization call.  Thereafter,
%    MORE should be TRUE to request the next index set.
%
%    Output, integer I_NEW, J_NEW, K_NEW, the next index set.  
%
%    Output, logical MORE_NEW, is TRUE until there are no more index sets to return.
%
  more_new = more;

  if ( ~more_new )
    more_new = 1;
    i_new = ic - n1;
    j_new = jc - n2;
    k_new = kc - n3;
    return
  end

  i_new = i;
  j_new = j;
  k_new = k;

  if ( i_new == ic + n1 & j_new == jc + n2 & k_new == kc + n3 ) 
    more_new = 0;
    return
  end
%
%  Increment K.
%
  k_new = k_new + 1;
%
%  Check K.
%
  if ( kc + n3 < k_new )
    k_new = kc - n3;
    j_new = j_new + 1;
  elseif ( k_new < kc + n3 & ...
    ( i_new == ic - n1 | i_new == ic + n1 | j_new == jc - n2 | j_new == jc + n2 ) ) 
    return
  else
    k_new = kc + n3;
    return
  end
%
%  Check J.
%
  if ( jc + n2 < j_new )
    j_new = jc - n2;
    i_new = i_new + 1;
  elseif ( j_new < jc + n2 & ...
    ( i_new == ic - n1 | i_new == ic + n1 | k_new == kc - n3 | k_new == kc + n3 ) )
    return
  else
    j_new = jc + n2;
    return
  end
