function [ i_new, j_new, more_new ] = index_box2_next_2d ( n1, n2, ic, jc, i, j, more )

%% INDEX_BOX2_NEXT_2D produces index vectors on the surface of a box in 2D.
%
%  Discussion:
%
%    The box is has center at (IC,JC), and has half-widths N1 and N2.
%    The index vectors are exactly those which are between (IC-N1,JC-N1) and
%    (IC+N1,JC+N2) with the property that at least one of I and J
%    is an "extreme" value.
%
%  Modified:
%
%    11 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N1, N2, the half-widths of the box, that is, the
%    maximum distance allowed between (IC,JC) and (I,J).
%
%    Input, integer IC, JC, the central cell of the box.
%
%    Input, integer I, J, the output value of I and J on the previous call.
%    Input values ignored on first call.
%
%    Input, logical MORE, set this to 0 on the first call, and therafter,
%    set it to its output value on the previous call.
%
%    Output, integer I_NEW, J_NEW, the next index set.  
%
%    Output, logical MORE_NEW, is FALSE (or 0) if there are no more indices
%    to return, and TRUE otherwise.
%
  i_new = i;
  j_new = j;
  more_new = more;

  if ( ~ more_new )
    more_new = 1;
    i_new = ic - n1;
    j_new = jc - n2;
    return
  end

  if ( i_new == ic + n1 & j_new == jc + n2 )
    more_new = 0;
    return
  end
%
%  Increment J.
%
  j_new = j_new + 1;
%
%  Check J.
%
  if ( jc + n2 < j_new )
    j_new = jc - n2;
    i_new = i_new + 1;
  elseif ( j_new < jc + n2 & ( i_new == ic - n1 | i_new == ic + n1 ) )
    return
  else
    j_new = jc + n2;
    return
  end
