function [ a, seed ] = i4vec_uniform ( n, b, c, seed )

%% I4VEC_UNIFORM returns a scaled pseudorandom I4VEC.
%
%  Modified:
%
%    21 September 2006
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N, the number of entries in the vector.
%
%    Input, integer B, C, the minimum and maximum acceptable values.
%
%    Input, integer SEED, a seed for the random number generator.
%
%    Output, integer A(N), the randomly chosen integer vector.
%
%    Output, integer SEED, the updated seed.
%
  if ( seed == 0 )
    fprintf ( 1, '\n' );
    fprintf ( 1, 'I4VEC_UNIFORM - Fatal error!\n' );
    fprintf ( 1, '  Input SEED = 0!\n' );
    error ( 'I4VEC_UNIFORM - Fatal error!' );
  end

  b = round ( b );
  c = round ( c );

  for i = 1 : n

    [ r, seed ] = r4_uniform_01 ( seed );

    a(i) = b + floor ( r * ( c + 1 - b ) );
  
    a(i) = max ( a(i), b );
    a(i) = min ( a(i), c );

  end

