function a_new = i4vec_sort_bubble_a ( n, a )

%% I4VEC_SORT_BUBBLE_A ascending sorts an integer vector using bubble sort.
%
%  Discussion:
%
%    Bubble sort is simple to program, but inefficient.  It should not
%    be used for large arrays.
%
%  Modified:
%
%    01 May 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N, the number of entries in the array.
%
%    Input, integer A(N), an unsorted array.
%
%    Output, integer A_NEW(N), the array has been sorted.
%
  a_new(1:n) = a(1:n);

  for i = 1 : n-1
    for j = i+1 : n
      if ( a_new(j) < a_new(i) )
        t        = a_new(i);
        a_new(i) = a_new(j);
        a_new(j) = t;
      end
    end
  end
