function a_new = i4mat_perm ( n, a, p )

%% I4MAT_PERM permutes the rows and columns of a square integer matrix.
%
%  Modified:
%
%    20 June 2004
%
%  Reference:
%
%    A Nijenhuis and H Wilf,
%    Combinatorial Algorithms,
%    Academic Press, 1978, second edition,
%    ISBN 0-12-519260-6.
%
%  Parameters:
%
%    Input, integer N, the order of the matrix.
%
%    Input, integer A(N,N), the matrix to be permuted.
%
%    Input, integer P(N), the permutation.  P(I) is the new number of row
%    and column I.
%
%    Output, integer A_NEW(N,N), the permuted matrix.
%
  a_new(1:n,1:n) = a(1:n,1:n);

  [ p, is, nc ] = perm_cycle ( n, 1, p );

  for i = 1 : n

    i1 = -p(i);

    if ( 0 < i1 )

      lc = 0;

      while ( 1 )

        i1 = p(i1);
        lc = lc + 1;

        if ( i1 <= 0 )
          break;
        end

      end

      i1 = i;

      for j = 1 : n

        if ( p(j) <= 0 )

          j2 = j;
          k = lc;

          while ( 1 )

            j1 = j2;
            it = a_new(i1,j1);

            while ( 1 )

              i1 = abs ( p(i1) );
              j1 = abs ( p(j1) );

              [ a_new(i1,j1), it ] = i4_swap ( a_new(i1,j1), it );

              if ( j1 ~= j2 )
                continue;
              end

              k = k - 1;

              if ( i1 == i )
                break;
              end

            end

            j2 = abs ( p(j2) );

            if ( k == 0 )
              break;
            end

          end

        end

      end

    end

  end
%
%  Restore the positive signs of the data.
%
  p(1:n) = abs ( p(1:n) );
