function [ a, degree ] = i4_to_i4poly ( intval, base )

%% I4_TO_I4POLY converts an integer to an integer polynomial in a given base.
%
%  Examples:
%
%    INTVAL  BASE  Degree     A (in reverse order!)
%
%         1     2       0     1
%         6     2       2     1  1  0
%        23     2       5     1  0  1  1  1
%        23     3       3     2  1  2
%        23     4       3     1  1  3
%        23     5       2     4  3
%        23     6       2     3  5
%        23    23       1     1  0
%        23    24       0    23
%
%  Modified:
%
%    05 July 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer INTVAL, an integer to be converted.
%
%    Input, integer BASE, the base, which should be greater than 1.
%
%    Output, integer A(1:DEGREE+1), contains the coefficients
%    of the polynomial expansion of INTVAL in base BASE.
%
%    Output, integer DEGREE, the degree of the polynomial.
%
  j = abs ( floor ( intval ) );

  degree = 0;

  a(degree+1) = mod ( j, base );

  j = j - a(degree+1);
  j = floor ( j / base );

  while ( 0 < j )

    degree = degree + 1;

    a(degree+1) = mod ( j, base );

    j = j - a(degree);
    j = floor ( j / base );

  end

  if ( intval < 0 )
    a(1:degree+1) = -a(1:degree+1);
  end
