function [ npart_new, a_new, mult_new, done_new ] = i4_partition_next ( n, ...
  npart, a, mult, done )

%% I4_PARTITION_NEXT generates the partitions of an integer, one at a time.
%
%  Comments:
%
%    The number of partitions of N is:
%
%      1     1
%      2     2
%      3     3
%      4     5
%      5     7
%      6    11
%      7    15
%      8    22
%      9    30
%     10    42
%     11    56
%     12    77
%     13   101
%     14   135
%     15   176
%     16   231
%     17   297
%     18   385
%     19   490
%     20   627
%     21   792
%     22  1002
%     23  1255
%     24  1575
%     25  1958
%     26  2436
%     27  3010
%     28  3718
%     29  4565
%     30  5604
%
%  Modified:
%
%    06 July 2004
%
%  Reference:
%
%    A Nijenhuis and H Wilf,
%    Combinatorial Algorithms,
%    Academic Press, 1978, second edition,
%    ISBN 0-12-519260-6.
%
%  Parameters:
%
%    Input, integer N, the integer to be partitioned.
%
%    Input, integer NPART, the output value of NPART_NEW on the previous call.
%
%    Input, integer A(N), the output value of A_NEW on the previous call.
%
%    Input, integer MULT(N), the output value of MULT_NEW on the previous call.
%
%    Input, logical DONE, is TRUE on the first call, to perform initialization.
%    On an initialization call, the input values of NPART, A and MULT are not needed.
%
%    Output, integer NPART_NEW, the number of "parts" in the next partition.
%
%    Output, integer A_NEW(N), the parts of the nextpartition.  The value N is 
%    represented by sum ( 1 <= I <= NPART_NEW ) MULT_NEW(I) * A_NEW(I).
%
%    Output, integer MULT_NEW(N), the multiplicities.
%
%    Output, logical DONE_NEW, is FALSE if there are more partitions, or TRUE
%    if there are no more.
%
  if ( n <= 0 )
    fprintf ( 1, '\n' );
    fprintf ( 1, 'I4_PARTITION_NEXT - Fatal error!\n' );
    fprintf ( 1, '  N must be positive.\n' );
    fprintf ( 1, '  The input value of N was %d\n', n );
    error ( 'I4_PARTITION_NEXT - Fatal error!' );
  end

  done_new = done;

  if ( done_new )

    a_new(1) = n;
    a_new(2:n) = 0;

    mult_new(1) = 1;
    mult_new(2:n) = 0;

    npart_new = 1;
    done_new = 0;

  else

    a_new(1:n) = a(1:n);
    mult_new(1:n) = mult(1:n);
    npart_new = npart;

    if ( 1 < a_new(npart_new) | 1 < npart_new )

      done_new = 0;

      if ( a_new(npart_new) == 1 )
        is = a_new(npart_new-1) + mult_new(npart_new);
        k = npart_new - 1;
      else
        is = a_new(npart_new);
        k = npart_new;
      end

      iw = a_new(k) - 1;
      iu = floor ( is / iw );
      iv = mod ( is, iw );
      mult_new(k) = mult_new(k) - 1;

      if ( mult_new(k) == 0 )
        k1 = k;
      else
        k1 = k + 1;
      end

      mult_new(k1) = iu;
      a_new(k1) = iw;

      if ( iv == 0 )
        npart_new = k1;
      else
        mult_new(k1+1) = 1;
        a_new(k1+1) = iv;
        npart_new = k1 + 1;
      end

    else
      done_new = 1;
    end

  end

