function [ npart_new, jarray_new, iarray_new, more_new ] = equiv_next ( ...
  n, npart, jarray, iarray, more )

%% EQUIV_NEXT computes the partitions of a set one at a time.
%
%  Definition:
%
%    A partition of a set assigns each element to exactly one subset.
%
%  Comments:
%
%    The number of partitions of a set of size N is the Bell number B(N).
%
%  Modified:
%
%    30 July 2004
%
%  Reference:
%
%    A Nijenhuis and H Wilf,
%    Combinatorial Algorithms,
%    Academic Press, 1978, second edition,
%    ISBN 0-12-519260-6.
%
%  Parameters:
%
%    Input, integer N, the number of elements in the set to be partitioned.
%
%    Input, integer NPART, the number of subsets in the previous partition.
%
%    Input, integer JARRAY(N), the number of elements in each subset 
%    of the previous partition.
%
%    Input, integer IARRAY(N), the subset to which each element belongs
%    in the previous partition.
%
%    Input, logical MORE, is set to FALSE on the first call, and the
%    input values of NPART, JARRAY and IARRAY are not needed.  On subsequent
%    calls, MORE should be TRUE, and NPART, JARRAY, and IARRAY should have the
%    values of the output quantities NPART_NEW, JARRAY_NEW and IARRAY_NEW
%    from the previous call.
%
%    Output, integer NPART_NEW, the number of subsets in the new partition.
%
%    Output, integer JARRAY_NEW(N), the number of elements in each subset 
%    of the new partition.
%
%    Output, integer IARRAY_NEW(N), the subset to which each element belongs
%    in the new partition.
%
%    Output, logical MORE_NEW, is TRUE as long as the new partition returned 
%    is not the last one.  When MORE_NEW is returned FALSE, all the partitions
%    have been computed and returned.
%
  more_new = more;

  if ( ~more_new )

    npart_new = 1;
    iarray_new(1:n) = 1;
    jarray_new(1) = n;
    jarray_new(2:n) = 0;

  else

    npart_new = npart;
    jarray_new(1:n) = jarray(1:n);
    iarray_new(1:n) = iarray(1:n);

    m = n;

    while ( jarray_new(iarray_new(m)) == 1 )
      iarray_new(m) = 1;
      m = m - 1;
    end

    l = iarray_new(m);
    npart_new = npart_new + m - n;
    jarray_new(1) = jarray_new(1) + n - m;

    if ( l == npart_new )
      npart_new = npart_new + 1;
      jarray_new(npart_new) = 0;
    end

    iarray_new(m) = l + 1;
    jarray_new(l) = jarray_new(l) - 1;
    jarray_new(l+1) = jarray_new(l+1) + 1;

  end

  more_new = ( npart_new ~= n );
