function dvec_print ( n, dvec, title )

%% DVEC_PRINT prints a decimal integer vector, with an optional title.
%
%  Discussion:
%
%    A DVEC is an integer vector of decimal digits, intended to
%    represent an integer.  DVEC(1) is the units digit, DVEC(N-1)
%    is the coefficient of 10**(N-2), and DVEC(N) contains sign
%    information.  It is 0 if the number is positive, and 1 if
%    the number is negative.
%
%    The vector is printed "backwards", that is, the first entry
%    printed is DVEC(N).
%
%  Modified:
%
%    02 December 2006
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N, the number of components of the vector.
%
%    Input, integer DVEC(N), the vector to be printed.
%
%    Input, string TITLE, a title to be printed first.
%    TITLE may be blank.
%
  if ( 0 < s_len_trim ( title ) )
    fprintf ( 1, '\n' );
    fprintf ( 1, '%s\n', title );
    fprintf ( 1, '\n' );
  end

  for ihi = n : -80 : 1
    ilo = max ( ihi - 80 + 1, 1 );
    for i = ihi : -1 : ilo
      fprintf ( 1, '%1d', dvec(i) );
    end
    fprintf ( 1, '\n' );
  end
