function deranged = derange_check ( n, a )

%% DERANGE_CHECK determines whether a permutation is a derangement.
%
%  Definition:
%
%    A derangement of the integers 1 through N is a permutation of the
%    integers such that the first value is not 1, the second is not 2,
%    and so on.
%
%  Modified:
%
%    12 June 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N, the number of objects permuted.
%
%    Input, integer A(N), a permutation of the integers 1 through N.
%
%    Output, logical DERANGED, is TRUE if A is a derangement, and
%    FALSE otherwise.
%
  for i = 1 : n
    if ( a(i) == i )
      deranged = 0;
      return
    end
  end

  deranged = 1;
