function [ nstack_new, stack_new, ncan_new ] = derange_back_candidate ( ...
  n, a, k, nstack, stack, ncan )

%% DERANGE_BACK_CANDIDATE finds possible values for the K-th entry of a derangement.
%
%  Modified:
%
%    13 July 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer N, the order of the derangement.
%
%    Input, integer A(N).  The first K-1 entries of A
%    record the currently set values of the derangement.
%
%    Input, integer K, the entry of the derangement for which candidates
%    are to be found.
%
%    Input, integer NSTACK, the length of the stack.
%
%    Input, integer STACK((N*(N+1))/2).  
%
%    Input, integer NCAN(N), the number of candidates for each level.
%
%    Output, integer NSTACK_NEW, the length of the output stack.
%
%    Output, integer STACK_NEW((N*(N+1))/2), contains candidates for entry K 
%    added to the end of the stack.
%
%    Output, integer NCAN_NEW(N), the number of candidates for each level.
%
  nstack_new = nstack;
  stack_new(1:nstack) = stack(1:nstack);
  ncan_new(1:n) = ncan(1:n);
%
%  Consider all the integers from 1 through N that have not been used yet.
%
  nfree = n - k + 1;

  ifree = perm_free ( a, k-1, nfree );
%
%  Everything but K is a legitimate candidate for the K-th entry.
%
  ncan_new(k) = 0;

  for ican = 1 : nfree

    if ( ifree(ican) ~= k )
      ncan_new(k) = ncan_new(k) + 1;
      nstack_new = nstack_new + 1;
      stack_new(nstack_new) = ifree(ican);
    end

  end

