function [ mantissa_new, exponent_new ] = dec_round ( mantissa, exponent, ...
  dec_digit )

%% DEC_ROUND rounds a decimal fraction to a given number of digits.
%
%  Discussion:
%
%    A decimal value is represented by MANTISSA * 10**EXPONENT.
%
%    The routine takes an arbitrary decimal fraction makes sure that 
%    MANTISSA has no more than DEC_DIGIT digits.
%
%  Modified:
%
%    22 July 2004
%
%  Author:
%
%    John Burkardt
%
%  Parameters:
%
%    Input, integer MANTISSA, EXPONENT, the coefficient and exponent
%    of a decimal fraction.  
%
%    Input, integer DEC_DIGIT, the number of decimal digits.
%
%    Output, integer MANTISSA_NEW, EXPONENT_NEW, the rounded data.
%    MANTISSA_NEW has no more than DEC_DIGIT decimal digits.
%
  mantissa_new = mantissa;
  exponent_new = exponent;

  if ( mantissa_new == 0 )
    exponent_new = 0;
    return
  end

  while ( 10^dec_digit <= abs ( mantissa_new ) )
    mantissa_new = round ( mantissa_new / 10.0E+00 );
    exponent_new = exponent_new + 1;
  end
%
%  Absorb trailing 0's into the exponent.
%
  while ( floor ( mantissa_new / 10 ) * 10 == mantissa_new )
    mantissa_new = mantissa_new / 10;
    exponent_new = exponent_new + 1;
  end

