function avw_view_hdr(avw)

% AVW_VIEW_HDR: View and modify Analyze header file
% 
% Useage: avw_view_hdr(avw)
% 
% Input avw can be generated by avw_hdr_read or avw_img_read
% 

% Licence:  GNU GPL, no express or implied warranties
% History:  06/2002, Darren.Weber@flinders.edu.au
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ~exist('avw','var'),
    msg = sprintf('AVW_VIEW_HDR: No input avw - see help gui_avw\n');
    error(msg);
end



% GUI General Parameters
GUIwidth  = 80;
GUIheight = 20;
GUI = figure('Name','AVWHDR','Tag','AVWHDR','units','characters',...
             'NumberTitle','off','HandleVisibility','callback',...
             'MenuBar','none','Position',[1 1 GUIwidth GUIheight]);
movegui(GUI,'center');

AVWHDR.gui = GUI;

Font.FontName   = 'Helvetica';
Font.FontUnits  = 'Pixels';
Font.FontSize   = 12;
Font.FontWeight = 'normal';
Font.FontAngle  = 'normal';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Analyze header display and modification...
Font.FontWeight = 'bold';

G.Tselectfield = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .9 .49 .09],'String','Select Header Fields','HorizontalAlignment','left');
G.Pselectfield = uicontrol('Parent',GUI,'Style','popup','Units','Normalized',Font,  ...
	'Position',[.51 .9 .48 .09],...
    'String',{'Header Key','Image Dimensions','Data History (optional)'},...
    'TooltipString','Select Header Fields to Display',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'field = get(AVWHDR.handles.Pselectfield,''Value'');',...
    'switch field, ',...
    'case 1, ',...
    '   set(AVWHDR.handles.Tsizeof_hdr,    ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Esizeof_hdr,    ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Tdata_type,     ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Edata_type,     ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Tdb_name,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Edb_name,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Textents,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Eextents,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Tsession_error, ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Esession_error, ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Tregular,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Eregular,       ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Thkey_un0,      ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Ehkey_un0,      ''Visible'',''on'');',...
    '   set(AVWHDR.handles.Tdim1,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim1,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim2,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim2,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim3,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim3,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim4,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim4,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim5,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim5,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim6,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim6,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim7,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim7,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim8,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim8,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim2,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim2,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim3,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim3,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim4,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim4,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim5,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim5,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim6,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim6,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim7,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim7,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim8,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim8,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvox_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evox_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdatatype,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edatatype,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tbitpix,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ebitpix,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvox_offset,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evox_offset,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Troi_scale,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eroi_scale,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tglmax,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eglmax,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tglmin,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eglmin,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tverified,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Everified,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcompressed,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecompressed,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_min,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_min,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_max,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_max,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfunused1,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efunused1,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfunused2,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efunused2,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim_un0,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim_un0,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tunused1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eunused1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdescrip,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edescrip,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Taux_file,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eaux_file,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Toriginator,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eoriginator,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tgenerated,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Egenerated,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tscannum,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Escannum,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpatient_id,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epatient_id,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Texp_date,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eexp_date,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Texp_time,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eexp_time,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsmin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esmin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsmax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esmax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tomin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eomin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tomax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eomax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tviews,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eviews,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvols_added,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evols_added,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tstart_field,   ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Estart_field,   ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfield_skip,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efield_skip,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Torient,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eorient,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Thist_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ehist_un0,      ''Visible'',''off'');',...
    'case 2, ',...
    '   set(AVWHDR.handles.Tsizeof_hdr,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esizeof_hdr,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdata_type,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edata_type,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdb_name,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edb_name,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Textents,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eextents,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsession_error, ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esession_error, ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tregular,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eregular,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Thkey_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ehkey_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim1,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim1,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim2,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim2,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim3,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim3,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim4,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim4,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim5,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim5,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim6,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim6,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim7,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim7,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim8,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim8,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim1,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim1,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim2,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim2,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim3,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim3,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim4,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim4,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim5,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim5,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim6,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim6,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim7,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim7,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpixdim8,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epixdim8,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tvox_units,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Evox_units,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tcal_units,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ecal_units,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdatatype,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edatatype,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tbitpix,        ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ebitpix,        ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tvox_offset,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Evox_offset,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Troi_scale,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eroi_scale,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tglmax,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eglmax,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tglmin,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eglmin,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tverified,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Everified,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tcompressed,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ecompressed,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tcal_min,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ecal_min,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tcal_max,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ecal_max,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tfunused1,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Efunused1,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tfunused2,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Efunused2,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdim_un0,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edim_un0,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tunused1,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eunused1,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tdescrip,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edescrip,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Taux_file,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eaux_file,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Toriginator,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eoriginator,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tgenerated,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Egenerated,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tscannum,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Escannum,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpatient_id,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epatient_id,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Texp_date,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eexp_date,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Texp_time,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eexp_time,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsmin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esmin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsmax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esmax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tomin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eomin,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tomax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eomax,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tviews,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eviews,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvols_added,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evols_added,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tstart_field,   ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Estart_field,   ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfield_skip,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efield_skip,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Torient,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eorient,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Thist_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ehist_un0,      ''Visible'',''off'');',...
    'case 3, ',...
    '   set(AVWHDR.handles.Tsizeof_hdr,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esizeof_hdr,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdata_type,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edata_type,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdb_name,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edb_name,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Textents,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eextents,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tsession_error, ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Esession_error, ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tregular,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eregular,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Thkey_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ehkey_un0,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim1,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim1,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim2,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim2,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim3,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim3,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim4,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim4,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim5,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim5,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim6,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim6,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim7,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim7,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim8,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim8,          ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim2,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim2,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim3,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim3,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim4,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim4,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim5,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim5,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim6,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim6,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim7,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim7,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tpixdim8,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Epixdim8,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvox_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evox_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_units,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdatatype,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edatatype,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tbitpix,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ebitpix,        ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tvox_offset,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Evox_offset,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Troi_scale,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eroi_scale,     ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tglmax,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eglmax,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tglmin,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eglmin,         ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tverified,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Everified,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcompressed,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecompressed,    ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_min,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_min,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tcal_max,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Ecal_max,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfunused1,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efunused1,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tfunused2,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Efunused2,      ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdim_un0,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Edim_un0,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tunused1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Eunused1,       ''Visible'',''off'');',...
    '   set(AVWHDR.handles.Tdescrip,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Edescrip,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Taux_file,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eaux_file,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Toriginator,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eoriginator,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tgenerated,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Egenerated,     ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tscannum,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Escannum,       ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tpatient_id,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Epatient_id,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Texp_date,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eexp_date,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Texp_time,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eexp_time,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tsmin,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Esmin,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tsmax,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Esmax,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tomin,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eomin,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tomax,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eomax,          ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tviews,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eviews,         ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tvols_added,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Evols_added,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tstart_field,   ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Estart_field,   ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Tfield_skip,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Efield_skip,    ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Torient,        ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Eorient,        ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Thist_un0,      ''Visible'',''on '');',...
    '   set(AVWHDR.handles.Ehist_un0,      ''Visible'',''on '');',...
    'end; ',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR field;'));



%%% BEGIN OF HEADER KEY (avw.hdr.hk)
Font.FontWeight = 'normal';

G.Tsizeof_hdr = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .8 .49 .09],'String','Size of Header','HorizontalAlignment','left');
G.Esizeof_hdr = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .8 .48 .09], 'String',num2str(double(avw.hdr.hk.sizeof_hdr)),...
    'TooltipString','Must indicate the byte size of the header file: int32, must = 348',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'size = 348; AVWHDR.avw.hdr.hk.sizeof_hdr = int32(size);',...
    'set(AVWHDR.handles.Esizeof_hdr,''String'', num2str(size));',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR size;'));

G.Tdata_type = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .7 .49 .09],'String','Data Type','HorizontalAlignment','left');
G.Edata_type = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .7 .48 .09], 'String',avw.hdr.hk.data_type,...
    'TooltipString','Not important: string',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hk.data_type = get(AVWHDR.handles.Edata_type,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tdb_name = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .6 .49 .09],'String','DB Name','HorizontalAlignment','left');
G.Edb_name = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .6 .48 .09], 'String',avw.hdr.hk.db_name,...
    'TooltipString','Not important: string',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hk.db_name = get(AVWHDR.handles.Edb_name,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Textents = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .5 .49 .09],'String','Extents','HorizontalAlignment','left');
G.Eextents = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .5 .48 .09], 'String',num2str(double(avw.hdr.hk.extents)),...
    'TooltipString','Should be 16384, the image file is created as contiguous with a minimum extent size: int32',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'extents = str2num(get(AVWHDR.handles.Eextents,''String''));',...
    'AVWHDR.avw.hdr.hk.extents = int32(extents);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR extents;'));

G.Tsession_error = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .4 .49 .09],'String','Session Error','HorizontalAlignment','left');
G.Esession_error = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .4 .48 .09], 'String',num2str(double(avw.hdr.hk.session_error)),...
    'TooltipString','Not important: int16',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'session_error = str2num(get(AVWHDR.handles.Esession_error,''String''));',...
    'AVWHDR.avw.hdr.hk.session_error = int16(session_error);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR session_error;'));

G.Tregular = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .3 .49 .09],'String','Regular','HorizontalAlignment','left');
G.Eregular = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .3 .48 .09], 'String',avw.hdr.hk.regular,...
    'TooltipString','Must be ''r'' to indicate that all images and volumes are the same size: string',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hk.regular = ''r'';',...
    'set(AVWHDR.handles.Eregular,''String'', ''r'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Thkey_un0 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .2 .49 .09],'String','Key Unused #0','HorizontalAlignment','left');
G.Ehkey_un0 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
	'Position',[.51 .2 .48 .09], 'String',avw.hdr.hk.hkey_un0,...
    'TooltipString','Unused key: string',...
    'Visible','on',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hk.hkey_un0 = get(AVWHDR.handles.Ehkey_un0,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));




%%% END OF HEADER KEY (avw.hdr.hk)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% BEGIN OF IMAGE DIMENSIONS (avw.hdr.dime)




G.Tdim1 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .8 .13 .09],'String','Dims: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim1 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .8 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(1))),...
    'TooltipString','Number of image dimensions used: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim1,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(1) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim2 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .7 .13 .09],'String','Dim 2: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim2 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .7 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(2))),...
    'TooltipString','Image dimension 2, x y or z: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim2,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(2) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim3 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .6 .13 .09],'String','Dim 3: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim3 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .6 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(3))),...
    'TooltipString','Image dimension 3, x y or z: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim3,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(3) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim4 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .5 .13 .09],'String','Dim 4: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim4 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .5 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(4))),...
    'TooltipString','Image dimension 4, x y or z: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim4,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(4) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim5 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .4 .13 .09],'String','Dim 5: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim5 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font, ...
    'Position',[.15 .4 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(5))),...
    'TooltipString','Image dimension 5, time: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim5,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(5) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim6 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .3 .13 .09],'String','Dim 6: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim6 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .3 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(6))),...
    'TooltipString','Image dimension 6: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim6,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(6) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim7 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .2 .13 .09],'String','Dim 7: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim7 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .2 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(7))),...
    'TooltipString','Image dimension 7: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim7,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(7) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tdim8 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .1 .13 .09],'String','Dim 8: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim8 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.15 .1 .09 .09], 'String',num2str(double(avw.hdr.dime.dim(8))),...
    'TooltipString','Image dimension 8: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Edim8,''String''));',...
    'AVWHDR.avw.hdr.dime.dim(8) = int16(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));





G.Tpixdim1 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .8 .13 .09],'String','Pix 1: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim1 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font, ...
    'Position',[.40 .8 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(1))),...
    'TooltipString','Pixel dimension 1: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim1,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(1) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim2 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .7 .13 .09],'String','Pix 2: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim2 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .7 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(2))),...
    'TooltipString','Pixel dimension 2: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim2,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(2) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim3 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .6 .13 .09],'String','Pix 3: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim3 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .6 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(3))),...
    'TooltipString','Pixel dimension 3: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim3,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(3) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim4 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .5 .13 .09],'String','Pix 4: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim4 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .5 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(4))),...
    'TooltipString','Pixel dimension 4: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim4,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(4) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim5 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .4 .13 .09],'String','Pix 5: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim5 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font, ...
    'Position',[.40 .4 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(5))),...
    'TooltipString','Pixel dimension 5: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim5,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(5) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim6 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .3 .13 .09],'String','Pix 6: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim6 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .3 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(6))),...
    'TooltipString','Pixel dimension 6: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim6,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(6) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim7 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .2 .13 .09],'String','Pix 7: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim7 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .2 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(7))),...
    'TooltipString','Pixel dimension 7: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim7,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(7) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));

G.Tpixdim8 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .1 .13 .09],'String','Pix 8: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epixdim8 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .1 .09 .09], 'String',num2str(double(avw.hdr.dime.pixdim(8))),...
    'TooltipString','Pixel dimension 8: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim = str2num(get(AVWHDR.handles.Epixdim8,''String''));',...
    'AVWHDR.avw.hdr.dime.pixdim(8) = single(dim);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim;'));








G.Tbitpix = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .8 .13 .09],'String','BitPix: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ebitpix = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .8 .09 .09], 'String',num2str(double(avw.hdr.dime.bitpix)),...
    'TooltipString','Bits Per Pixel: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'bitpix = str2num(get(AVWHDR.handles.Ebitpix,''String''));',...
    'AVWHDR.avw.hdr.dime.bitpix = int16(bitpix);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR bitpix;'));

G.Tdatatype = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .7 .13 .09],'String','Type: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edatatype = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .7 .09 .09], 'String',num2str(double(avw.hdr.dime.datatype)),...
    'TooltipString','Data Type: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'type = str2num(get(AVWHDR.handles.Edatatype,''String''));',...
    'AVWHDR.avw.hdr.dime.datatype = int16(type);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR type;'));

G.Tvox_units = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .6 .13 .09],'String','Vox: ',...
    'Visible','off','HorizontalAlignment','right');
G.Evox_units = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font, ...
    'Position',[.66 .6 .09 .09], 'String',avw.hdr.dime.vox_units,...
    'TooltipString','Voxel units: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.dime.vox_units = get(AVWHDR.handles.Evox_units,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tvox_offset = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .5 .13 .09],'String','Offset: ',...
    'Visible','off','HorizontalAlignment','right');
G.Evox_offset = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font, ...
    'Position',[.66 .5 .09 .09], 'String',num2str(double(avw.hdr.dime.vox_offset)),...
    'TooltipString','Voxel Offset: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'vox_offset = str2num(get(AVWHDR.handles.Evox_offset,''String''));',...
    'AVWHDR.avw.hdr.dime.vox_offset = single(vox_offset);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR vox_offset;'));

G.Tglmin = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .4 .13 .09],'String','GL Min: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eglmin = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .4 .09 .09], 'String',num2str(double(avw.hdr.dime.glmin)),...
    'TooltipString','Global Minimum: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'glmin = str2num(get(AVWHDR.handles.Eglmin,''String''));',...
    'AVWHDR.avw.hdr.dime.glmin = int32(glmin);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR glmin;'));

G.Tglmax = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .3 .13 .09],'String','GL Max: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eglmax = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .3 .09 .09], 'String',num2str(double(avw.hdr.dime.glmax)),...
    'TooltipString','Global Maximum: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'glmax = str2num(get(AVWHDR.handles.Eglmax,''String''));',...
    'AVWHDR.avw.hdr.dime.glmax = int32(glmax);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR glmax;'));

G.Troi_scale = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .2 .13 .09],'String','ROI: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eroi_scale = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .2 .09 .09], 'String',num2str(double(avw.hdr.dime.roi_scale)),...
    'TooltipString','Region of Interest Scale: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'roi_scale = str2num(get(AVWHDR.handles.Eroi_scale,''String''));',...
    'AVWHDR.avw.hdr.dime.roi_scale = single(roi_scale);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR roi_scale;'));

G.Tcal_units = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .1 .13 .09],'String','Cal: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ecal_units = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .1 .09 .09], 'String',avw.hdr.dime.cal_units,...
    'TooltipString','Calibration Units: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.dime.cal_units = get(AVWHDR.handles.Ecal_units,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));


G.Tverified = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .8 .13 .09],'String','Verif: ',...
    'Visible','off','HorizontalAlignment','right');
G.Everified = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .8 .09 .09], 'String',num2str(double(avw.hdr.dime.verified)),...
    'TooltipString','Verified: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'verified = str2num(get(AVWHDR.handles.Everified,''String''));',...
    'AVWHDR.avw.hdr.dime.verified = int32(verified);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR verified;'));

G.Tcompressed = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .7 .13 .09],'String','Comp: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ecompressed = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .7 .09 .09], 'String',num2str(double(avw.hdr.dime.compressed)),...
    'TooltipString','Compression: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'compressed = str2num(get(AVWHDR.handles.Ecompressed,''String''));',...
    'AVWHDR.avw.hdr.dime.compressed = int32(compressed);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR compressed;'));

G.Tcal_min = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .6 .13 .09],'String','Cal_Min: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ecal_min = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .6 .09 .09], 'String',num2str(double(avw.hdr.dime.cal_min)),...
    'TooltipString','Calibration Min: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'cal_min = str2num(get(AVWHDR.handles.Ecal_min,''String''));',...
    'AVWHDR.avw.hdr.dime.cal_min = single(cal_min);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR cal_min;'));

G.Tcal_max = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .5 .13 .09],'String','Cal_Max: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ecal_max = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .5 .09 .09], 'String',num2str(double(avw.hdr.dime.cal_max)),...
    'TooltipString','Calibration Max: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'cal_max = str2num(get(AVWHDR.handles.Ecal_max,''String''));',...
    'AVWHDR.avw.hdr.dime.cal_max = single(cal_max);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR cal_max;'));

G.Tfunused1 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .4 .13 .09],'String','FUn1: ',...
    'Visible','off','HorizontalAlignment','right');
G.Efunused1 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .4 .09 .09], 'String',num2str(double(avw.hdr.dime.funused1)),...
    'TooltipString','funused1, unused float field: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'funused1 = str2num(get(AVWHDR.handles.Efunused1,''String''));',...
    'AVWHDR.avw.hdr.dime.funused1 = single(funused1);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR funused1;'));

G.Tfunused2 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .3 .13 .09],'String','FUn2: ',...
    'Visible','off','HorizontalAlignment','right');
G.Efunused2 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .3 .09 .09], 'String',num2str(double(avw.hdr.dime.funused2)),...
    'TooltipString','funused2, unused float field: float',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'funused2 = str2num(get(AVWHDR.handles.Efunused2,''String''));',...
    'AVWHDR.avw.hdr.dime.funused2 = single(funused2);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR funused2;'));

G.Tdim_un0 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .2 .13 .09],'String','DimUn: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edim_un0 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .2 .09 .09], 'String',num2str(double(avw.hdr.dime.dim_un0)),...
    'TooltipString','Dim_Un0, unused field: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'dim_un0 = str2num(get(AVWHDR.handles.Edim_un0,''String''));',...
    'AVWHDR.avw.hdr.dime.dim_un0 = int16(dim_un0);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR dim_un0;'));

G.Tunused1 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .1 .13 .09],'String','Unused: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eunused1 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .1 .09 .09], 'String',num2str(double(avw.hdr.dime.unused1)),...
    'TooltipString','Unused int field: int16',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'unused1 = str2num(get(AVWHDR.handles.Eunused1,''String''));',...
    'AVWHDR.avw.hdr.dime.unused1 = int16(unused1);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR unused1;'));



%%% END OF IMAGE DIMENSIONS (avw.hdr.dime)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% BEGIN OF IMAGE HISTORY (avw.hdr.hist)


G.Tdescrip = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .8 .18 .09],'String','Description: ',...
    'Visible','off','HorizontalAlignment','right');
G.Edescrip = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.20 .8 .79 .09], 'String',avw.hdr.hist.descrip,...
    'TooltipString','Description: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.descrip = get(AVWHDR.handles.Edescrip,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Taux_file = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .7 .18 .09],'String','Aux File: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eaux_file = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.20 .7 .79 .09], 'String',avw.hdr.hist.aux_file,...
    'TooltipString','Auxilliary File: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.aux_file = get(AVWHDR.handles.Eaux_file,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Toriginator = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .6 .18 .09],'String','Originator: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eoriginator = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.20 .6 .29 .09], 'String',avw.hdr.hist.originator,...
    'TooltipString','Originator: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.originator = get(AVWHDR.handles.Eoriginator,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tgenerated = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .6 .18 .09],'String','Generated: ',...
    'Visible','off','HorizontalAlignment','right');
G.Egenerated = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.70 .6 .29 .09], 'String',avw.hdr.hist.generated,...
    'TooltipString','Generated: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.generated = get(AVWHDR.handles.Egenerated,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tscannum = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .5 .18 .09],'String','Scan Num: ',...
    'Visible','off','HorizontalAlignment','right');
G.Escannum = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.20 .5 .29 .09], 'String',avw.hdr.hist.scannum,...
    'TooltipString','Scan Number: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.scannum = get(AVWHDR.handles.Escannum,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tpatient_id = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .5 .18 .09],'String','Patient ID: ',...
    'Visible','off','HorizontalAlignment','right');
G.Epatient_id = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.70 .5 .29 .09], 'String',avw.hdr.hist.patient_id,...
    'TooltipString','Patient ID: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.patient_id = get(AVWHDR.handles.Epatient_id,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Texp_date = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .4 .18 .09],'String','Exp Date: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eexp_date = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.20 .4 .29 .09], 'String',avw.hdr.hist.exp_date,...
    'TooltipString','Exp Date: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.exp_date = get(AVWHDR.handles.Eexp_date,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Texp_time = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .4 .18 .09],'String','Exp Time: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eexp_time = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.70 .4 .29 .09], 'String',avw.hdr.hist.exp_time,...
    'TooltipString','Exp Time: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.exp_time = get(AVWHDR.handles.Eexp_time,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Tsmin = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .3 .13 .09],'String','Smin: ',...
    'Visible','off','HorizontalAlignment','right');
G.Esmin = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.16 .3 .09 .09], 'String',num2str(double(avw.hdr.hist.smin)),...
    'TooltipString','Smin: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'smin = str2num(get(AVWHDR.handles.Esmin,''String''));',...
    'AVWHDR.avw.hdr.hist.smin = int32(smin);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR smin;'));

G.Tsmax = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .3 .13 .09],'String','Smax: ',...
    'Visible','off','HorizontalAlignment','right');
G.Esmax = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .3 .09 .09], 'String',num2str(double(avw.hdr.hist.smax)),...
    'TooltipString','Smax: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'smax = str2num(get(AVWHDR.handles.Esmax,''String''));',...
    'AVWHDR.avw.hdr.hist.smax = int32(smax);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR smax;'));

G.Tomin = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .2 .13 .09],'String','Omin: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eomin = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.16 .2 .09 .09], 'String',num2str(double(avw.hdr.hist.omin)),...
    'TooltipString','Omin: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'omin = str2num(get(AVWHDR.handles.Eomin,''String''));',...
    'AVWHDR.avw.hdr.hist.omin = int32(omin);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR omin;'));

G.Tomax = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.26 .2 .13 .09],'String','Omax: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eomax = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.40 .2 .09 .09], 'String',num2str(double(avw.hdr.hist.omax)),...
    'TooltipString','Omax: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'omax = str2num(get(AVWHDR.handles.Eomax,''String''));',...
    'AVWHDR.avw.hdr.hist.omax = int32(omax);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR omax;'));

G.Tviews = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .3 .13 .09],'String','Views: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eviews = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .3 .09 .09], 'String',num2str(double(avw.hdr.hist.views)),...
    'TooltipString','Views: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'views = str2num(get(AVWHDR.handles.Eviews,''String''));',...
    'AVWHDR.avw.hdr.hist.views = int32(views);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR views;'));

G.Tvols_added = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .3 .13 .09],'String','VolAdd: ',...
    'Visible','off','HorizontalAlignment','right');
G.Evols_added = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .3 .09 .09], 'String',num2str(double(avw.hdr.hist.vols_added)),...
    'TooltipString','Volumes Added: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'vols_added = str2num(get(AVWHDR.handles.Evols_added,''String''));',...
    'AVWHDR.avw.hdr.hist.vols_added = int32(vols_added);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR vols_added;'));

G.Tstart_field = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.51 .2 .13 .09],'String','Start F: ',...
    'Visible','off','HorizontalAlignment','right');
G.Estart_field = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.66 .2 .09 .09], 'String',num2str(double(avw.hdr.hist.start_field)),...
    'TooltipString','Start Field: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'start_field = str2num(get(AVWHDR.handles.Estart_field,''String''));',...
    'AVWHDR.avw.hdr.hist.start_field = int32(start_field);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR start_field;'));

G.Tfield_skip = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.76 .2 .13 .09],'String','Skip F: ',...
    'Visible','off','HorizontalAlignment','right');
G.Efield_skip = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.90 .2 .09 .09], 'String',num2str(double(avw.hdr.hist.field_skip)),...
    'TooltipString','Skip Field: int32',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'field_skip = str2num(get(AVWHDR.handles.Efield_skip,''String''));',...
    'AVWHDR.avw.hdr.hist.field_skip = int32(field_skip);',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR field_skip;'));

G.Torient = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .1 .13 .09],'String','Orient: ',...
    'Visible','off','HorizontalAlignment','right');
G.Eorient = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.16 .1 .09 .09], 'String',avw.hdr.hist.orient,...
    'TooltipString','Orientation, valid values are 0..5: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.orient = get(AVWHDR.handles.Eorient,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));

G.Thist_un0 = uicontrol('Parent',GUI,'Style','text','Units','Normalized',Font, ...
    'Position',[.01 .01 .13 .09],'String','Hist Un: ',...
    'Visible','off','HorizontalAlignment','right');
G.Ehist_un0 = uicontrol('Parent',GUI,'Style','edit','Units','Normalized',Font,  ...
    'Position',[.16 .01 .09 .09], 'String',avw.hdr.hist.hist_un0,...
    'TooltipString','History unused field: string',...
    'Visible','off',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata'');',...
    'AVWHDR.avw.hdr.hist.hist_un0 = get(AVWHDR.handles.Ehist_un0,''String'');',...
    'set(gcbf,''Userdata'',AVWHDR); clear AVWHDR;'));





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Font.FontWeight = 'bold';

% OK: Return the header!
G.Bdone = uicontrol('Parent',GUI,'Style','pushbutton','Units','Normalized', Font, ...
    'Position',[.51 .01 .24 .08],...
    'String','OK','BusyAction','queue',...
    'TooltipString','Save the hdr parameters.',...
    'BackgroundColor',[0.0 0.5 0.0],...
    'ForegroundColor', [1 1 1], 'HorizontalAlignment', 'center',...
    'Callback',strcat('AVWHDR = get(gcbf,''Userdata''); ',...
    'avw = AVWHDR.avw;',...
    'close gcbf; clear AVWHDR;'));

% Cancel
G.Bquit = uicontrol('Parent',GUI,'Style','pushbutton','Units','Normalized', Font, ...
    'Position',[.76 .01 .23 .08],...
    'String','CANCEL','BusyAction','queue',...
    'BackgroundColor',[0.75 0.0 0.0],...
    'ForegroundColor', [1 1 1], 'HorizontalAlignment', 'center',...
    'Callback','close gcbf;');


% Update the gui_struct handles for this gui
AVWHDR.avw = avw;
AVWHDR.handles = G;
set(AVWHDR.gui,'Userdata',AVWHDR);

return
