% evaluate spline 
%	based on 7 dir box spline 
%	with coefficients chosen for the 3-unit sphere % and 
% compare with values for the 3-unit sphere
    dim = 3;
    dir = 7;
    R = 3^2;
    Xi = [1 0 0 1 -1 1 -1;
	  0 1 0 1 1 -1 -1;
	  0 0 1 1 1  1  1];
    n = 1;  % samples
    xx = rand(3,n)

%  spline coefficients 
    lft = -3;
    rgt = 2;
    XX = [];
    for u1 = lft:rgt,
	for u2 = lft:rgt,
	    for u3 = -5:0,
		u = [u1; u2; u3];
		XX = [XX xx-u*ones(1,n)];  % note: opposite shift
	    end;
	end;
    end;
    sz = size(XX)
    fu = bxval(Xi,XX);

    sz = size(fu)
    savfu = fu;
    fval = 0*ones(1,n);	% accumulate the values
    for u1 = lft:rgt,
	for u2 = lft:rgt,
	    for u3 = -5:0,
		u = [u1; u2; u3];
		% pick out values corresponding to the 
		% box spline shifted by u
		head = fu(1:n);
		len = length(fu);
		fu = fu(n+1:len);
		% weigh the values by the box spline coefficient
		% test cases
		%1. coeff = R	%(0, 0, 0)
		%2. coeff = u(1)+1/2;	%(1, 0, 0)
		%3. coeff = u(3)+5/2;	%(0, 0, 1)
		%4. coeff = u(1)*u(2) + u(1)/2 + u(2)/2 + 1/4;	%(1, 1, 0)
		%5. coeff = u(1)*u(3) + u(3)/2 + 5*u(1)/2 + 5/4;	%(1, 0, 1)
		%%coeff = (u(1)^2)/2 - (1/12) + u(1)/2;	%(2, 0, 0)
		%6. coeff = (u(1)^2) - (1/6) + u(1);        %(2, 0, 0)
		%%coeff = ( u(3)^2 )/2 + 35/12 + 5*u(3)/2;
		%7. coeff = ( u(3)^2 ) + 35/6 + 5*u(3);
		w1 = ( u(1)^2 )/2 - 1/12 + u(1)/2;
		w2 = ( u(2)^2 )/2 - 1/12 + u(2)/2;
		w3 = ( u(3)^2 )/2 + 35/12 + 5*u(3)/2;
		coeff = 2*w1 + 2*w2 + 2*w3 - R;
		fval = fval + coeff*head;
	    end;
	end;
    end;
    fval
    %1. shouldbe  = R
    %2. shouldbe  = xx(1,:)
    %3. shouldbe  = xx(3,:)
    %4. shouldbe  = xx(1,:) .* xx(2,:)
    %5. shouldbe  = xx(1,:) .* xx(3,:)
    %6. shouldbe  = xx(1,:) .* xx(1,:)
    %7. shouldbe  = xx(3,:) .* xx(3,:)
    shouldbe  = xx(1,:).^2 + xx(2,:).^2 + xx(3,:).^2 - ones(1,n)*R
