

function m  =  condir(m1,dir)
%
%        m  =  condir(m1, dir)
%
%  this specialization of  convol.m  returns the discrete convol-
%  ution of the mask contained in  m1  with the one-direction 
%  mask specified in  dir =  [x; y]*[0:(n-1)] .
 

%  C de Boor: 12 oct 90/ 25 jun 92
 

oo = [1; 1];
[z1,rc1,mask1] = msbrk(m1); supp1 = [oo rc1];
[jj,n] = size(dir); dor = dir+ones(jj,n); z2 = [1; 1];
if (dir(1,n)<0),
  z2(1) = 1-dir(1,n); dor(1,:) = dor(1,:)-dir(1,n)*ones(1,n); end
if (dir(2,n)<0),
  z2(2) = 1-dir(2,n); dor(2,:) = dor(2,:)-dir(2,n)*ones(1,n); end
supp2 = [oo abs(dir(:,n))+oo];
% compute support and center of convolved mask:
supp = supp1+supp2-(z1+z2)*ones(1,2);
z = oo-supp(:,1); supp= supp + z*ones(1,2); rc = supp(:,2);
% compute convolved mask:
mask= zeros(rc(1),rc(2)); shsupp1 = supp1+(z-z1-z2)*ones(1,2);
rangex = shsupp1(1,1):shsupp1(1,2);
rangey = shsupp1(2,1):shsupp1(2,2);
for i = 1:n;
   mask(rangex+dor(1,i),rangey+dor(2,i))= ...
                   mask(rangex+dor(1,i),rangey+dor(2,i)) + mask1;
   end
m = msmak(z,mask);
 

