function [P] = find_support_mesh(Xi)
	[s n] = size(Xi);
	% Each "mesh point" is built by adding subset of the directions,
	% i.e., each direction has "1" or "0" for linear combination
	% thus 2^n cases.
	M = 2^n;
	P = zeros(M,s);	% list of the "mesh points" (2^n by s)
	for i = 0:M-1
		% To keep the size of array ("a") constant, we add "M".
		% Otherwise, its size varies depending on the number of leading zeros.
		a = dec2bin(M+i);	
		% When computing the linear combination, we don't use the first element 
		% because of the reason above.
		% We need to subtract '0' (ascii code) since array "a" is composed of characters.
		P(i+1,:) = (a(2:size(a,2))-'0')*(Xi');
	end
	P = unique(P,'rows');
end
