function [P] = find_support_mesh(Xi)
	[s n] = size(Xi);

	supp_lower = zeros(s);
	supp_upper = zeros(s);

	for i=1:s	% For each dimension
		for j=1:n
			if Xi(i,j) < 0
				supp_lower(i) = supp_lower(i) + Xi(i,j);
			else
				supp_upper(i) = supp_upper(i) + Xi(i,j);
			end
		end
	end
	switch(s)
		case 1
			[x] = ndgrid(supp_lower(1):supp_upper(1));
			P = [x(:)];
		case 2
			[x y] = ndgrid(	supp_lower(1):supp_upper(1),	...
							supp_lower(2):supp_upper(2));
			P = [x(:) y(:)];
		case 3
			[x y z] = ndgrid(	supp_lower(1):supp_upper(1),	...
								supp_lower(2):supp_upper(2),	...
								supp_lower(3):supp_upper(3));
			P = [x(:) y(:) z(:)];
	end
end

