function [rho] = find_rho(Xi)
	[s,n] = size(Xi);
	m = 2^n;
	rho = n;
	for i=1:(m-1)
		a = dec2bin(m+i);
		a = a(2:n+1)-'0';
		idx = find(a==1);
		ncols = n-size(idx,2);
		if ncols < rho
			Zeta = Xi(:,idx);
			if rank(Zeta) < s
				rho = ncols;
			end
		end
	end
end
