function [y] = eval_trivariate_bez(c,u,d)
%
%	Evaluation of trivariate Bezier polynomial using de Casteljau's algorithm
%
%	c : Bezier coefficients
%	u : input in barycentric coordinate
%	d : degree
%
	global	Bary_inv;
	global	Bary;
	n = size(u,1);

	for i0 = 0:(d-1)
		for i1 = 0:(d-1-i0)
			for i2 = 0:(d-1-i0-i1)
				i3 = d-1 - i0 - i1 - i2;
				t(i0+1,i1+1,i2+1,i3+1,:)												...
										=	u(:,1).*c(:,Bary_inv(i0+2,i1+1,i2+1,i3+1))	...
										+	u(:,2).*c(:,Bary_inv(i0+1,i1+2,i2+1,i3+1))	...
										+	u(:,3).*c(:,Bary_inv(i0+1,i1+1,i2+2,i3+1))	...
										+	u(:,4).*c(:,Bary_inv(i0+1,i1+1,i2+1,i3+2));
			end
		end
	end
	t1 = zeros(n,1);
	t2 = zeros(n,1);
	t3 = zeros(n,1);
	t4 = zeros(n,1);
	for k=(d-2):-1:0
		for i0=0:k
			for i1=0:(k-i0)
				for i2=0:(k-i0-i1)
					i3=k-i0-i1-i2;
					t1(:) = t(i0+2,i1+1,i2+1,i3+1,:);
					t2(:) = t(i0+1,i1+2,i2+1,i3+1,:);
					t3(:) = t(i0+1,i1+1,i2+2,i3+1,:);
					t4(:) = t(i0+1,i1+1,i2+1,i3+2,:);
					t(i0+1,i1+1,i2+1,i3+1,:)	...
								=	u(:,1).*t1 + u(:,2).*t2 + u(:,3).*t3 + u(:,4).*t4;
				end
			end
		end
	end
	y = zeros(n,1);
	y(:) = t(1,1,1,1,:);
end
