clear all;

select_box = 7;	% input selection

switch(select_box)
	case 1
		Xi = [1  1 0  0;
			  1 -1 1  1;
			  0  0 1 -1];
	case 2
		% trivariate 6-direction box spline
		Xi = [1 -1 1  1 0  0;
			  1  1 0  0 1 -1;
			  0  0 1 -1 1  1];
	case 3
		% `transformed' 6-direction box spline
		Q = [ 1  1 -1;
		     -1  1  1;
		      1 -1  1]/2;
		Xi = [1 -1 1  1 0  0;
			  1  1 0  0 1 -1;
			  0  0 1 -1 1  1];
		Xi = Q*Xi;
	case 4
		% trivariate 7-direction box spline
		Xi = [1 0 0 1  1 -1 -1;
			  0 1 0 1 -1  1 -1;
			  0 0 1 1 -1 -1  1];
	case 5
		% 5-directional box spline
		Xi = [1 0 0 2 -2;
			  0 1 0 1  1;
			  0 0 1 1  1];
	case 6
		% `modified' 7-direction box spline
		Xi = [2 0 0 1  1 -1 -1;
			  0 2 0 1 -1  1 -1;
			  0 0 2 1 -1 -1  1];
	case 7
		% trivariate 6-direction box spline
		Xi = [1 -1 1  1 0  0 1 0 0;
			  1  1 0  0 1 -1 0 1 0;
			  0  0 1 -1 1  1 0 0 1];
end
figure(1);
clf;
p = compute_support(Xi);
daspect([1 1 1]);
axis tight;


