clear all;

P = path;
path(P,'../box_eval');
P = path;
path(P,'../deboor');

format rat;

select_Xi = 5;

switch(select_Xi)
	case 1
		Xi = [1 -1 0  0 1 -1;
		      0  0 1 -1 1 -1];
	case 1.1
		Xi = [1 -1 0  0 2 -2;
		      0  0 1 -1 2 -2];
	case 2
		Xi = [1 1 -1 -1];
	case 3
		% 6-direction box-spline
		Xi = [1 -1 1  1 0  0;
		      1  1 0  0 1 -1;
		      0  0 1 -1 1  1];
	case 3.1
		% `transformed' 6-direction box-spline
		Xi = [1 -1 1  1 0  0;
		      1  1 0  0 1 -1;
		      0  0 1 -1 1  1];
		Q = [ 1  1 -1;
		     -1  1  1;
		      1 -1  1]/2;
		Xi = Q*Xi;
	case 4
		% 8-direction box-spline
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Xi = [d1 d1 d2 d2 d3 d3 d4 d4];
	case 4.1
		% 8-direction box-spline
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Xi = [d1 -d1 d2 -d2 d3 -d3 d4 -d4];
	case 5	
		% 7-directional box spline
		Xi = [1 0 0 1  1 -1 -1;
		      0 1 0 1 -1  1 -1;
		      0 0 1 1 -1 -1  1];
	case 6
		Xi = [1 1 -1 -1 0 0  0  0;
		      0 0  0  0 1 1 -1 -1];
	case 7
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Q = [0 1 1;
		     1 0 1;
		     1 1 0]/(-2);
		Xi = [d1 d1 d2 d2 d3 d3 d4 d4];
		Xi = Q*Xi;
	case 7.1
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Q = [0 1 1;
		     1 0 1;
		     1 1 0]/(-2);
		Xi = [d1 -d1 d2 -d2 d3 -d3 d4 -d4];
		Xi = Q*Xi;
	case 7.2
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Q = [0 1 1;
		     1 0 1;
		     1 1 0]/(-2);
		Xi = [d1 d1 d1 d2 d2 d2 d3 d3 d3 d4 d4 d4];
		Xi = Q*Xi;
	case 7.3
		d1 = [ 1 -1 -1]';
		d2 = [-1  1 -1]';
		d3 = [-1 -1  1]';
		d4 = [ 1  1  1]';
		Q = [0 1 1;
		     1 0 1;
		     1 1 0]/(-2);
		Xi = [d1 d2 d3 d4];
		Xi = Q*Xi;
end

Xi

[s n] = size(Xi);

switch(s)
	case 1	% uni-variate box-spline
%		[nonzero_mesh mesh_val quasi_coeff] = compute_g_1d(Xi);

	case 2	% bi-variate box-spline
%		[nonzero_mesh mesh_val quasi_coeff] = compute_g_2d(Xi);

	case 3	% tri-variate box-spline
		[nonzero_mesh mesh_val quasi_coeff] = compute_g_3d(Xi);
end

[nonzero_mesh mesh_val]
quasi_coeff



