function [p] = compute_support(Xi)
	[s n] = size(Xi);
	% Each `mesh point' in the support of the box spline
	% is built by adding subset of the directions,
	% i.e., each direction has "1" or "0" for linear combination
	% thus 2^n cases.
	M = 2^n;
	P = zeros(M,s);	% list of the mesh points (2^n by s)
	for i = 0:M-1
		% We generate binary number to be used as the coefficients
		% of the linear combination of the directions.
		% To keep the size of array (`a') constant, we add `M'.
		% Otherwise, its size varies depending on the number of leading zeros.
		a = dec2bin(M+i);	

		% When computing the linear combination, we drop the first element 
		% because of the reason above.
		% We need to subtract `0' (ascii code) since array `a' is composed 
		% of characters.
		P(i+1,:) = (a(2:size(a,2))-'0')*(Xi');
	end

	% Filters to get unique points only.
	P = unique(P,'rows');	

	% Computes the convex hull of the mesh points to visualize the support.
	K = convhulln(P);	

	% Colors the triangles on the same face in the same color.
	FaceColor = color_faces(K,P);	

	p = patch(	'Faces',			K,			...
				'Vertices',			P,			...
				'FaceVertexCData',	FaceColor,	...
				'FaceColor',		'flat',		...
				'FaceLighting',		'none',		...
				'EdgeColor',		'none');
end


