%
% Computes the coefficients for the quasi-interpolant
% of the box-spline defined by given direction matrix, `Xi'.
% The `recursive' formula is based on the formula
% (III-19,p.69) of the `Box Splines (Carl de Boor et.al)' book.
%
function [nonzero_mesh mesh_val quasi_coeff] = compute_g_3d(Xi)
	[s n] = size(Xi);

	global g;

	% Collects all the mesh points where the box-spline
	% value is not zero. This is required to compute the `mu'
	% defined on p.69 of `Box Splines' book.
	tic;
	[nonzero_mesh,mesh_val] = collect_nonzero_mesh(Xi);
	disp('Computing non-zero mesh points complete.');
	toc;

	%
	% rho(Xi) := m(Xi) + 1
	%
	% where m(Xi) is defined on p.9 of `Box Splines' book.
	% You can also find the definition of `rho' in appendix of
	%
	% `Box-spline based CSG blends' by Jorg Peters and Michael Wittman.
	%
	% http://www.cise.ufl.edu/research/SurfLab/pre99-papers/jorgs_papers.html
	%
	rho = find_rho(Xi);
	m = rho-1;

	% Initializes the base case of the recursion.
	% See p.68 of `Box Splines' book.
	put_g([0 0 0],1);

	n = 1;

	for d=1:m
		for x_alpha = 0:d
			for y_alpha = 0:(d-x_alpha)
				z_alpha = d - (x_alpha+y_alpha);

				% Now we have `|alpha|=d'.
				alpha = [x_alpha y_alpha z_alpha];

				val = 0;

				% For each beta with `beta<=alpha'...
				for x_beta = 0:alpha(1)
					for y_beta = 0:alpha(2)
						for z_beta = 0:alpha(3)
							beta = [x_beta y_beta z_beta];

							if ~isequal(alpha,beta)
								val = val + mu(nonzero_mesh,mesh_val,alpha-beta)*get_g(beta);
							end
						end
					end
				end
				val_g = normalized_power([0 0 0],alpha) - val;

				val_g = approx_rat(val_g);

				put_g(alpha,val_g);

%				disp(sprintf('g(%g,%g,%g) computed',alpha));

				if val_g ~= 0
					quasi_coeff(n,:) = [alpha val_g];
					n = n+1;
				end
			end
		end
	end
end

function put_g(idx,val)
	global g;
	g(idx(1)+1,idx(2)+1,idx(3)+1) = val;
end
function val_g = get_g(idx)
	global g;
	val_g = g(idx(1)+1,idx(2)+1,idx(3)+1);
end

