function [FaceColor] = color_faces(K,P)
	nfaces = 0;

	% # of triangles of the convex hull
	nK = size(K,1);	

	% contains the `face index' for each triangle
	face_index = zeros(nK,1);	

	for i = 1:nK

		% if the face index is not assigned to this triangle yet
		if face_index(i) == 0	

			% increase # of faces (to be used as face index)
			nfaces = nfaces+1;	

			% assigns new face index to this triangle
			face_index(i) = nfaces;	

			if i < nK
				% vertex indices of this triangle
				Vi = P(K(i,:),:);	

				% computes the normal vector for this triangle
				Ni = cross(Vi(2,:) - Vi(1,:),Vi(3,:) - Vi(1,:));	

				% Searches all the triangles which lie in the same face
				% iterating rest of the triangles (which have not been assigned
				% any face index yet).
				for j = i+1:nK

					Vj = P(K(j,:),:);

					Nj = cross(Vj(2,:) - Vj(1,:),Vj(3,:) - Vj(1,:));

					% Two triangles are regarded to be in the same face
					% if they are in the same plane.
					% (This works because the input is a convex hull.)
					%
					% (No `tolerance' is being considered yet...)

					% 1. compares normals
					if isequal(cross(Ni,Nj),[0 0 0])	

						% 2. compares `distance'
						if isequal(Ni*Vi(1,:)',Ni*Vj(1,:)')	
							face_index(j) = nfaces;
						end
					end
				end
			end
		end
	end

	% Assgins random color for each face. (expecting each ends up with a different color)
	for i = 1:nfaces
		color_list(i,:) = [rand rand rand];
	end

	% Actually assigns the color for each triangle.
	for i = 1:nK
		FaceColor(i,:) = color_list(face_index(i),:);
	end
end
