clear all;
%clf;

P = path;
path(P,'../common');
P = path;
path(P,'../deboor');
P = path;
path(P,'../box_eval');
P = path;
path(P,'../mri_toolbox_v1.5');

% First several global variables are to be initialized.

global Bary;		% degree 4 barycentric combinations
global Bary_inv;
global Tets;		% hash table for the tetrahedra in a cube
global iTets;		% index list of valid tetrahedra
global BezCoeffInt;	% quartic Bezier tetrahedra converted from trivariate 7-directional box spline
global BezCoeffRat;
global invTets;
global CubesFilled;
global Xi;
global Supp_min;
global Supp_max;
global nSupp;
global Denom;

Xi = [1 0 0 1  1 -1 -1;
      0 1 0 1 -1  1 -1;
      0 0 1 1 -1 -1  1];

Supp_min = [-2 -2 -2];
Supp_max = [ 3  3  3];
nSupp = Supp_max - Supp_min;
Denom = 2^9*3;

[Bary Bary_inv] = tri_bary(4);
[Tets iTets] = d7_hash_tet;
load 'd7_bez_coeff_int.mat' BezCoeffInt;
load 'd7_bez_coeff_rat.mat' BezCoeffRat;
load 'd7_invtets.mat' invTets;
load 'd7_cubes_filled.mat' CubesFilled;
