function [Tets,iTets] = d7_hash_tet

	% - Generates hash table which contains four vertices of the tetrahedra.

	iTets(1,:) = bin2dec('000111');
	iTets(2,:) = bin2dec('100110');
	iTets(3,:) = bin2dec('100111');
	iTets(4,:) = bin2dec('000110');

	iTets(5,:) = bin2dec('011001');
	iTets(6,:) = bin2dec('111000');
	iTets(7,:) = bin2dec('111001');
	iTets(8,:) = bin2dec('011000');

	iTets(9,:) = bin2dec('001111');
	iTets(10,:)= bin2dec('011101');
	iTets(11,:)= bin2dec('011111');
	iTets(12,:)= bin2dec('001101');

	iTets(13,:)= bin2dec('100010');
	iTets(14,:)= bin2dec('110000');
	iTets(15,:)= bin2dec('110010');
	iTets(16,:)= bin2dec('100000');

	iTets(17,:)= bin2dec('110111');
	iTets(18,:)= bin2dec('111011');
	iTets(19,:)= bin2dec('111111');
	iTets(20,:)= bin2dec('110011');

	iTets(21,:)= bin2dec('000100');
	iTets(22,:)= bin2dec('001000');
	iTets(23,:)= bin2dec('001100');
	iTets(24,:)= bin2dec('000000');

	% Please refer to "find_tet.m" for the way of indexing tetrahedra.

	c = [1 1 1;1 1 1;1 1 1;1 1 1];

	Tets(bin2dec('000111')+1,:,:) = [0 0 0;1 0 0;1  1 -1;1  1  1]+c;
	Tets(bin2dec('100110')+1,:,:) = [0 0 0;1 0 0;1 -1  1;1 -1 -1]+c;
	Tets(bin2dec('100111')+1,:,:) = [0 0 0;1 0 0;1  1  1;1 -1  1]+c;	
	Tets(bin2dec('000110')+1,:,:) = [0 0 0;1 0 0;1 -1 -1;1  1 -1]+c;

	Tets(bin2dec('011001')+1,:,:) = [0 0 0;-1 0 0;-1  1  1;-1  1 -1]+c;
	Tets(bin2dec('111000')+1,:,:) = [0 0 0;-1 0 0;-1 -1 -1;-1 -1  1]+c;
	Tets(bin2dec('111001')+1,:,:) = [0 0 0;-1 0 0;-1 -1  1;-1  1  1]+c;
	Tets(bin2dec('011000')+1,:,:) = [0 0 0;-1 0 0;-1  1 -1;-1 -1 -1]+c;

	Tets(bin2dec('001111')+1,:,:) = [0 0 0;0 1 0; 1 1  1; 1 1 -1]+c;
	Tets(bin2dec('011101')+1,:,:) = [0 0 0;0 1 0;-1 1 -1;-1 1  1]+c;
	Tets(bin2dec('011111')+1,:,:) = [0 0 0;0 1 0;-1 1  1; 1 1  1]+c;
	Tets(bin2dec('001101')+1,:,:) = [0 0 0;0 1 0; 1 1 -1;-1 1 -1]+c;

	Tets(bin2dec('100010')+1,:,:) = [0 0 0;0 -1 0; 1 -1 -1; 1 -1  1]+c;
	Tets(bin2dec('110000')+1,:,:) = [0 0 0;0 -1 0;-1 -1  1;-1 -1 -1]+c;
	Tets(bin2dec('110010')+1,:,:) = [0 0 0;0 -1 0; 1 -1  1;-1 -1  1]+c;
	Tets(bin2dec('100000')+1,:,:) = [0 0 0;0 -1 0;-1 -1 -1; 1 -1 -1]+c;

	Tets(bin2dec('110111')+1,:,:) = [0 0 0;0 0 1; 1 -1 1; 1  1 1]+c;
	Tets(bin2dec('111011')+1,:,:) = [0 0 0;0 0 1;-1  1 1;-1 -1 1]+c;
	Tets(bin2dec('111111')+1,:,:) = [0 0 0;0 0 1; 1  1 1;-1  1 1]+c;
	Tets(bin2dec('110011')+1,:,:) = [0 0 0;0 0 1;-1 -1 1; 1 -1 1]+c;

	Tets(bin2dec('000100')+1,:,:) = [0 0 0;0 0 -1; 1  1 -1; 1 -1 -1]+c;
	Tets(bin2dec('001000')+1,:,:) = [0 0 0;0 0 -1;-1 -1 -1;-1  1 -1]+c;
	Tets(bin2dec('001100')+1,:,:) = [0 0 0;0 0 -1;-1  1 -1; 1  1 -1]+c;
	Tets(bin2dec('000000')+1,:,:) = [0 0 0;0 0 -1; 1 -1 -1;-1 -1 -1]+c;

	Tets = Tets/2;
end
