function [icube itet] = d7_find_tet(p)
	global Supp_min;

	n = size(p,1);

	icube = floor(p);

	p_cube = p - floor(p);

	% We can decide to which tetrahedron the input point belongs by testing against all the six hyperplanes defined by all the combinations of 7 directions.
	% Since there are six of such planes, we have 2^6 = 64 cases but only 24 of them are valid ones.
	% They are:
	%
	% (1) [ 0 -1 1]x - 1/2 = 0: defined by [ 1  1  1] & [ 1 -1 -1]
	% (2) [-1  0 1]x - 1/2 = 0: defined by [ 1  1  1] & [-1  1 -1]
	% (3) [-1  1 0]x - 1/2 = 0: defined by [ 1  1  1] & [-1 -1  1]
	% (4) [ 1  1 0]x - 1/2 = 0: defined by [ 1 -1 -1] & [-1  1 -1]
	% (5) [ 1  0 1]x - 1/2 = 0: defined by [ 1 -1 -1] & [-1 -1  1]
	% (6) [ 0  1 1]x - 1/2 = 0: defined by [-1  1 -1] & [-1 -1  1]
	%
	% Here is the list of the tetrahedra defined.
	%
	% NOTE: When hashing, we transform each of elements (+/-) to map them to valid MatLab matrix indices.

	% six normal vector of the planes
	N = [ 0 -1 1;
		 -1  0 1;
		 -1  1 0;
		  1  1 0;
		  1  0 1;
		  0  1 1];

	p = p_cube*N'-repmat([0 0 0 1 1 1],n,1);

	itet = (p >= 0)*2.^[5 4 3 2 1 0]';
end
