function d7_export_povray_bez_basis(fid,threshold,bez_scale)
	global	CubesFilled;
	global	BezCoeffInt;
	global	iTets;
	global	invTets;
	global	Tets;
	global	Supp_min;
	global	nSupp;
	global	color_for_all;
	global	Denom;


	format rat;

	scale = Denom;

	nCubesFilled = size(CubesFilled,1);
	nTets = size(iTets,1);


	for i = 1:nCubesFilled
		icube = CubesFilled(i,:);
		for j = 1:nTets
%		for j = nTets:-1:1
			itet = iTets(j);
			invtet = invTets(itet+1,:);
			bez_coeff = bez_scale*BezCoeffInt(d7_convert_index(icube,itet),:);
			bez_coeff_max = max(bez_coeff);
			bez_coeff_min = min(bez_coeff);
			if (bez_coeff_min > threshold*scale) || (bez_coeff_max < threshold*scale)
				continue;
			end
			str_invtet1 = sprintf('%g,%g,%g,%g,', invtet(1),invtet(2),invtet(3),invtet(4));
			str_invtet2 = sprintf('%g,%g,%g,%g,', invtet(5),invtet(6),invtet(7),invtet(8));
			str_invtet3 = sprintf('%g,%g,%g,%g,', invtet(9),invtet(10),invtet(11),invtet(12));
			str_invtet4 = sprintf('%g,%g,%g,%g', invtet(13),invtet(14),invtet(15),invtet(16));
			str_invtet = sprintf('\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s',...
							str_invtet1,str_invtet2,str_invtet3,str_invtet4);

			str_coeff1 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(1),bez_coeff(2),bez_coeff(3),bez_coeff(4),bez_coeff(5));
			str_coeff2 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(6),bez_coeff(7),bez_coeff(8),bez_coeff(9),bez_coeff(10));
			str_coeff3 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(11),bez_coeff(12),bez_coeff(13),bez_coeff(14),bez_coeff(15));
			str_coeff4 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(16),bez_coeff(17),bez_coeff(18),bez_coeff(19),bez_coeff(20));
			str_coeff5 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(21),bez_coeff(22),bez_coeff(23),bez_coeff(24),bez_coeff(25));
			str_coeff6 = sprintf('%g,%g,%g,%g,%g,', bez_coeff(26),bez_coeff(27),bez_coeff(28),bez_coeff(29),bez_coeff(30));
			str_coeff7 = sprintf('%g,%g,%g,%g,%g', bez_coeff(31),bez_coeff(32),bez_coeff(33),bez_coeff(34),bez_coeff(35));
			str_coeff = sprintf('\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s\n\t\t\t\t\t%s',	...
				str_coeff1,str_coeff2,str_coeff3,str_coeff4,str_coeff5,str_coeff6,str_coeff7);


			tet = zeros(4,3);
			tet(:,:) = Tets(itet+1,:,:);

			n(1,:) = -cross(tet(2,:)-tet(1,:),tet(3,:)-tet(1,:));
			n(2,:) = -cross(tet(4,:)-tet(2,:),tet(3,:)-tet(2,:));
			n(3,:) = -cross(tet(4,:)-tet(1,:),tet(2,:)-tet(1,:));
			n(4,:) = -cross(tet(3,:)-tet(1,:),tet(4,:)-tet(1,:));

			n1 = n(1,:);
			n2 = n(2,:);
			n3 = n(3,:);
			n4 = n(4,:);

			len1 = sqrt(n1*n1');
			nn1 = n1./len1;
			d1 = n1*tet(1,:)';
			nd1 = d1/len1;

			len2 = sqrt(n2*n2');
			nn2 = n2./len2;
			d2 = n2*tet(2,:)';
			nd2 = d2/len2;

			len3 = sqrt(n3*n3');
			nn3 = n3./len3;
			d3 = n3*tet(1,:)';
			nd3 = d3/len3;

			len4 = sqrt(n4*n4');
			nn4 = n4./len4;
			d4 = n4*tet(1,:)';
			nd4 = d4/len4;

%			str_pln1 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)-PLANE_OFFSET', n1, d1);
%			str_pln2 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)-PLANE_OFFSET', n2, d2);
%			str_pln3 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)-PLANE_OFFSET', n3, d3);
%			str_pln4 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)-PLANE_OFFSET', n4, d4);

			str_pln1 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n1, d1);
			str_pln2 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n2, d2);
			str_pln3 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n3, d3);
			str_pln4 = sprintf('(%g)*x+(%g)*y+(%g)*z-(%g)+THRESHOLD-PLANE_OFFSET', n4, d4);

			str_bez = sprintf('-f_bez_tri_4(x,y,z,%s,%s)\n', str_invtet, str_coeff);

			fprintf(fid,'\t\tisosurface{\n');
			fprintf(fid,'\t\t\tfunction{\n');
%			fprintf(fid,'\t\t\t\tmax(%s/%f-THRESHOLD,max(%s,max(%s,max(%s,%s))))',str_bez,Denom,str_pln1,str_pln2,str_pln3,str_pln4);
			fprintf(fid,'\t\t\t\tmax(%s/%f,max(%s,max(%s,max(%s,%s))))',str_bez,scale,str_pln1,str_pln2,str_pln3,str_pln4);
			fprintf(fid,'\n\t\t\t}\n');
%			fprintf(fid,'\t\t\tthreshold 0\n');
			fprintf(fid,'\t\t\tthreshold THRESHOLD\n');
			fprintf(fid,'\t\t\tmax_gradient MAX_GRADIENT\n');
			fprintf(fid,'\t\t\taccuracy ACCURACY\n');
			fprintf(fid,'\t\t\tcontained_by {box {<0-PLANE_OFFSET,0-PLANE_OFFSET,0-PLANE_OFFSET>,\n');
			fprintf(fid,'\t\t\t\t<1+PLANE_OFFSET,1+PLANE_OFFSET,1+PLANE_OFFSET>}}\n');

			fprintf(fid, '\t\t\ttranslate <%g,%g,%g>\n', icube-Supp_min-(nSupp/2));

			if ~color_for_all
				fprintf(fid,'\t\t\ttexture {\n');
				fprintf(fid,'\t\t\t\tpigment{color <%g,%g,%g>}\n',rand,rand,rand);
				fprintf(fid,'\t\t\t\tfinish{IsoFinish}\n\t\t\t}\n');
			end

			fprintf(fid,'\t\t}\n');

		end
	end
end

